/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.data.xml.impl.EnchantSkillGroupsData;
import com.l2jserver.gameserver.model.L2EnchantSkillGroup;
import com.l2jserver.gameserver.model.L2EnchantSkillLearn;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.ArrayList;
import java.util.List;

public final class ExEnchantSkillInfo
extends L2GameServerPacket {
    private final List<Integer> _routes;
    private final int _id;
    private final int _lvl;
    private boolean _maxEnchanted;

    public ExEnchantSkillInfo(int id, int lvl) {
        block5: {
            this._routes = new ArrayList<Integer>();
            this._maxEnchanted = false;
            this._id = id;
            this._lvl = lvl;
            L2EnchantSkillLearn enchantLearn = EnchantSkillGroupsData.getInstance().getSkillEnchantmentBySkillId(this._id);
            if (enchantLearn == null) break block5;
            if (this._lvl > 100) {
                this._maxEnchanted = enchantLearn.isMaxEnchant(this._lvl);
                L2EnchantSkillGroup.EnchantSkillHolder esd = enchantLearn.getEnchantSkillHolder(this._lvl);
                if (esd != null) {
                    this._routes.add(this._lvl);
                }
                int skillLvL = this._lvl % 100;
                for (int route : enchantLearn.getAllRoutes()) {
                    if (route * 100 + skillLvL == this._lvl) continue;
                    this._routes.add(route * 100 + skillLvL);
                }
            } else {
                for (int route : enchantLearn.getAllRoutes()) {
                    this._routes.add(route * 100 + 1);
                }
            }
        }
    }

    @Override
    protected void writeImpl() {
        this.writeC(254);
        this.writeH(42);
        this.writeD(this._id);
        this.writeD(this._lvl);
        this.writeD(this._maxEnchanted ? 0 : 1);
        this.writeD(this._lvl > 100 ? 1 : 0);
        this.writeD(this._routes.size());
        for (int level : this._routes) {
            this.writeD(level);
        }
    }
}

