/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.MapRegionManager;
import com.l2jserver.gameserver.model.PartyMatchWaitingList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ExListPartyMatchingWaitingRoom
extends L2GameServerPacket {
    private static final int TOTAL = 64;
    private final int totalMatchingPlayers;
    private final List<L2PcInstance> players;

    public ExListPartyMatchingWaitingRoom(int page, int minLevel, int maxLevel, Set<Integer> classes, String filter) {
        List<L2PcInstance> matchingPlayers = PartyMatchWaitingList.getInstance().findPlayers(minLevel, maxLevel, classes, filter);
        this.totalMatchingPlayers = matchingPlayers.size();
        this.players = matchingPlayers.stream().skip((page - 1) * 64).limit(page * 64).collect(Collectors.toList());
    }

    @Override
    protected void writeImpl() {
        this.writeC(254);
        this.writeH(54);
        this.writeD(this.totalMatchingPlayers);
        this.writeD(this.players.size());
        for (L2PcInstance player : this.players) {
            this.writeS(player.getName());
            this.writeD(player.getActiveClass());
            this.writeD(player.getLevel());
            this.writeD(MapRegionManager.getInstance().getMapRegion(player).getBbs());
            Map<Integer, Long> instances = InstanceManager.getInstance().getAllInstanceTimes(player.getObjectId());
            this.writeD(instances.size());
            for (Integer id : instances.keySet()) {
                this.writeD(id);
            }
        }
    }
}

