/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.data.json.ExperienceData;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public class GMViewCharacterInfo
extends L2GameServerPacket {
    private final L2PcInstance _activeChar;
    private final int _runSpd;
    private final int _walkSpd;
    private final int _swimRunSpd;
    private final int _swimWalkSpd;
    private final int _flyRunSpd;
    private final int _flyWalkSpd;
    private final double _moveMultiplier;

    public GMViewCharacterInfo(L2PcInstance cha) {
        this._activeChar = cha;
        this._moveMultiplier = cha.getMovementSpeedMultiplier();
        this._runSpd = (int)Math.round(cha.getRunSpeed() / this._moveMultiplier);
        this._walkSpd = (int)Math.round(cha.getWalkSpeed() / this._moveMultiplier);
        this._swimRunSpd = (int)Math.round(cha.getSwimRunSpeed() / this._moveMultiplier);
        this._swimWalkSpd = (int)Math.round(cha.getSwimWalkSpeed() / this._moveMultiplier);
        this._flyRunSpd = cha.isFlying() ? this._runSpd : 0;
        this._flyWalkSpd = cha.isFlying() ? this._walkSpd : 0;
    }

    @Override
    protected final void writeImpl() {
        this.writeC(149);
        this.writeD(this._activeChar.getX());
        this.writeD(this._activeChar.getY());
        this.writeD(this._activeChar.getZ());
        this.writeD(this._activeChar.getHeading());
        this.writeD(this._activeChar.getObjectId());
        this.writeS(this._activeChar.getName());
        this.writeD(this._activeChar.getRace().ordinal());
        this.writeD(this._activeChar.getAppearance().getSex() ? 1 : 0);
        this.writeD(this._activeChar.getClassId().getId());
        this.writeD(this._activeChar.getLevel());
        this.writeQ(this._activeChar.getExp());
        this.writeF(ExperienceData.getInstance().getPercentFromCurrentLevel(this._activeChar.getExp(), this._activeChar.getLevel()));
        this.writeD(this._activeChar.getSTR());
        this.writeD(this._activeChar.getDEX());
        this.writeD(this._activeChar.getCON());
        this.writeD(this._activeChar.getINT());
        this.writeD(this._activeChar.getWIT());
        this.writeD(this._activeChar.getMEN());
        this.writeD(this._activeChar.getMaxHp());
        this.writeD((int)this._activeChar.getCurrentHp());
        this.writeD(this._activeChar.getMaxMp());
        this.writeD((int)this._activeChar.getCurrentMp());
        this.writeD(this._activeChar.getSp());
        this.writeD(this._activeChar.getCurrentLoad());
        this.writeD(this._activeChar.getMaxLoad());
        this.writeD(this._activeChar.getPkKills());
        for (int slot : this.getPaperdollOrder()) {
            this.writeD(this._activeChar.getInventory().getPaperdollObjectId(slot));
        }
        for (int slot : this.getPaperdollOrder()) {
            this.writeD(this._activeChar.getInventory().getPaperdollItemDisplayId(slot));
        }
        for (int slot : this.getPaperdollOrder()) {
            this.writeD(this._activeChar.getInventory().getPaperdollAugmentationId(slot));
        }
        this.writeD(this._activeChar.getInventory().getTalismanSlots());
        this.writeD(this._activeChar.getInventory().canEquipCloak() ? 1 : 0);
        this.writeD((int)this._activeChar.getPAtk(null));
        this.writeD((int)this._activeChar.getPAtkSpd());
        this.writeD((int)this._activeChar.getPDef(null));
        this.writeD(this._activeChar.getEvasionRate(null));
        this.writeD(this._activeChar.getAccuracy());
        this.writeD(this._activeChar.getCriticalHit(null, null));
        this.writeD((int)this._activeChar.getMAtk(null, null));
        this.writeD(this._activeChar.getMAtkSpd());
        this.writeD((int)this._activeChar.getPAtkSpd());
        this.writeD((int)this._activeChar.getMDef(null, null));
        this.writeD(this._activeChar.getPvpFlag());
        this.writeD(this._activeChar.getKarma());
        this.writeD(this._runSpd);
        this.writeD(this._walkSpd);
        this.writeD(this._swimRunSpd);
        this.writeD(this._swimWalkSpd);
        this.writeD(this._flyRunSpd);
        this.writeD(this._flyWalkSpd);
        this.writeD(this._flyRunSpd);
        this.writeD(this._flyWalkSpd);
        this.writeF(this._moveMultiplier);
        this.writeF(this._activeChar.getAttackSpeedMultiplier());
        this.writeF(this._activeChar.getCollisionRadius());
        this.writeF(this._activeChar.getCollisionHeight());
        this.writeD(this._activeChar.getAppearance().getHairStyle());
        this.writeD(this._activeChar.getAppearance().getHairColor());
        this.writeD(this._activeChar.getAppearance().getFace());
        this.writeD(this._activeChar.isGM() ? 1 : 0);
        this.writeS(this._activeChar.getTitle());
        this.writeD(this._activeChar.getClanId());
        this.writeD(this._activeChar.getClanCrestId());
        this.writeD(this._activeChar.getAllyId());
        this.writeC(this._activeChar.getMountType().ordinal());
        this.writeC(this._activeChar.getPrivateStoreType().getId());
        this.writeC(this._activeChar.hasDwarvenCraft() ? 1 : 0);
        this.writeD(this._activeChar.getPkKills());
        this.writeD(this._activeChar.getPvpKills());
        this.writeH(this._activeChar.getRecSystem().getLeft());
        this.writeH(this._activeChar.getRecSystem().getHave());
        this.writeD(this._activeChar.getClassId().getId());
        this.writeD(0);
        this.writeD(this._activeChar.getMaxCp());
        this.writeD((int)this._activeChar.getCurrentCp());
        this.writeC(this._activeChar.isRunning() ? 1 : 0);
        this.writeC(321);
        this.writeD(this._activeChar.getPledgeClass());
        this.writeC(this._activeChar.isNoble() ? 1 : 0);
        this.writeC(this._activeChar.isHero() ? 1 : 0);
        this.writeD(this._activeChar.getAppearance().getNameColor());
        this.writeD(this._activeChar.getAppearance().getTitleColor());
        byte attackAttribute = this._activeChar.getAttackElement();
        this.writeH(attackAttribute);
        this.writeH(this._activeChar.getAttackElementValue(attackAttribute));
        for (byte i = 0; i < 6; i = (byte)(i + 1)) {
            this.writeH(this._activeChar.getDefenseElementValue(i));
        }
        this.writeD(this._activeChar.getFame());
        this.writeD(this._activeChar.getVitalityPoints());
    }
}

