/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.agathion.Agathion;
import com.l2jserver.gameserver.agathion.repository.AgathionRepository;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.serverpackets.AbstractItemPacket;
import com.l2jserver.gameserver.network.serverpackets.ExBR_AgathionEnergyInfo;
import com.l2jserver.gameserver.network.serverpackets.ExQuestItemList;
import java.util.LinkedList;
import java.util.List;

public final class ItemList
extends AbstractItemPacket {
    private final L2PcInstance player;
    private final List<L2ItemInstance> items = new LinkedList<L2ItemInstance>();
    private final List<L2ItemInstance> agathions = new LinkedList<L2ItemInstance>();
    private final boolean showWindow;

    public ItemList(L2PcInstance player, boolean showWindow) {
        this.player = player;
        this.showWindow = showWindow;
        for (L2ItemInstance item : player.getInventory().getItems()) {
            Agathion agathion;
            if (!item.isQuestItem()) {
                this.items.add(item);
            }
            if ((agathion = AgathionRepository.getInstance().getByItemId(item.getId())) == null || agathion.getMaxEnergy() <= 0) continue;
            this.agathions.add(item);
        }
    }

    @Override
    protected void writeImpl() {
        this.writeC(17);
        this.writeH(this.showWindow ? 1 : 0);
        this.writeH(this.items.size());
        this.items.forEach(this::writeItem);
        this.writeInventoryBlock(this.player.getInventory());
        if (!this.agathions.isEmpty()) {
            this.player.sendPacket(new ExBR_AgathionEnergyInfo(this.agathions));
        }
    }

    @Override
    public void runImpl() {
        ((L2GameClient)this.getClient()).sendPacket(new ExQuestItemList(this.player));
    }
}

