/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.interfaces.IPositionable;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.mmocore.SendablePacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class L2GameServerPacket
extends SendablePacket<L2GameClient> {
    private static final Logger LOG = LoggerFactory.getLogger(L2GameServerPacket.class);
    private boolean _invisible = false;
    private static final int[] PAPERDOLL_ORDER = new int[]{0, 8, 9, 4, 13, 14, 1, 5, 7, 10, 6, 11, 12, 23, 5, 2, 3, 16, 15, 17, 18, 19, 20, 21, 22, 24};

    public boolean isInvisible() {
        return this._invisible;
    }

    public void setInvisible(boolean b) {
        this._invisible = b;
    }

    protected void writeLoc(IPositionable loc) {
        this.writeD(loc.getX());
        this.writeD(loc.getY());
        this.writeD(loc.getZ());
    }

    protected int[] getPaperdollOrder() {
        return PAPERDOLL_ORDER;
    }

    protected void write() {
        try {
            this.writeImpl();
        }
        catch (Exception e) {
            LOG.error("Client: {} - Failed writing: {} ; {}", ((L2GameClient)this.getClient()).toString(), ((Object)((Object)this)).getClass().getSimpleName(), e.getMessage(), e);
        }
    }

    public void runImpl() {
    }

    protected abstract void writeImpl();
}

