/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.interfaces.IPositionable;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class MagicSkillUse
extends L2GameServerPacket {
    private final int _skillId;
    private final int _skillLevel;
    private final int _hitTime;
    private final int _reuseDelay;
    private final L2Character _activeChar;
    private final L2Character _target;
    private final List<Integer> _unknown = Collections.emptyList();
    private final List<Location> _groundLocations;

    public MagicSkillUse(L2Character cha, L2Character target, int skillId, int skillLevel, int hitTime, int reuseDelay) {
        this._activeChar = cha;
        this._target = target;
        this._skillId = skillId;
        this._skillLevel = skillLevel;
        this._hitTime = hitTime;
        this._reuseDelay = reuseDelay;
        this._groundLocations = cha.isPlayer() && cha.getActingPlayer().getCurrentSkillWorldPosition() != null ? Collections.singletonList(cha.getActingPlayer().getCurrentSkillWorldPosition()) : Collections.emptyList();
    }

    public MagicSkillUse(L2Character cha, int skillId, int skillLevel, int hitTime, int reuseDelay) {
        this(cha, cha, skillId, skillLevel, hitTime, reuseDelay);
    }

    @Override
    protected void writeImpl() {
        this.writeC(72);
        this.writeD(this._activeChar.getObjectId());
        this.writeD(this._target.getObjectId());
        this.writeD(this._skillId);
        this.writeD(this._skillLevel);
        this.writeD(this._hitTime);
        this.writeD(this._reuseDelay);
        this.writeLoc(this._activeChar);
        this.writeH(this._unknown.size());
        Iterator<Object> iterator = this._unknown.iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            this.writeH(n);
        }
        this.writeH(this._groundLocations.size());
        for (IPositionable iPositionable : this._groundLocations) {
            this.writeLoc(iPositionable);
        }
        this.writeLoc(this._target);
    }
}

