/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.data.xml.impl.RecipeData;
import com.l2jserver.gameserver.model.L2RecipeList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipeItemMakeInfo
extends L2GameServerPacket {
    private static final Logger LOG = LoggerFactory.getLogger(RecipeItemMakeInfo.class);
    private final int _id;
    private final L2PcInstance _activeChar;
    private final boolean _success;

    public RecipeItemMakeInfo(int id, L2PcInstance player, boolean success) {
        this._id = id;
        this._activeChar = player;
        this._success = success;
    }

    public RecipeItemMakeInfo(int id, L2PcInstance player) {
        this._id = id;
        this._activeChar = player;
        this._success = true;
    }

    @Override
    protected final void writeImpl() {
        L2RecipeList recipe = RecipeData.getInstance().getRecipeList(this._id);
        if (recipe != null) {
            this.writeC(221);
            this.writeD(this._id);
            this.writeD(recipe.isDwarvenRecipe() ? 0 : 1);
            this.writeD((int)this._activeChar.getCurrentMp());
            this.writeD(this._activeChar.getMaxMp());
            this.writeD(this._success ? 1 : 0);
        } else {
            LOG.info("Character: {}: Requested unexisting recipe with id = {}", (Object)((L2GameClient)this.getClient()).getActiveChar(), (Object)this._id);
        }
    }
}

