/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.ArrayList;
import java.util.List;

public class SellList
extends L2GameServerPacket {
    private final L2PcInstance _activeChar;
    private final L2MerchantInstance _lease;
    private final long _money;
    private final List<L2ItemInstance> _selllist = new ArrayList<L2ItemInstance>();

    public SellList(L2PcInstance player) {
        this._activeChar = player;
        this._lease = null;
        this._money = this._activeChar.getAdena();
        this.doLease();
    }

    public SellList(L2PcInstance player, L2MerchantInstance lease) {
        this._activeChar = player;
        this._lease = lease;
        this._money = this._activeChar.getAdena();
        this.doLease();
    }

    private void doLease() {
        if (this._lease == null) {
            for (L2ItemInstance item : this._activeChar.getInventory().getItems()) {
                if (item.isEquipped() || !item.isSellable() || this._activeChar.hasSummon() && item.getObjectId() == this._activeChar.getSummon().getControlObjectId()) continue;
                this._selllist.add(item);
            }
        }
    }

    @Override
    protected final void writeImpl() {
        this.writeC(6);
        this.writeQ(this._money);
        this.writeD(this._lease == null ? 0 : 1000000 + this._lease.getTemplate().getId());
        this.writeH(this._selllist.size());
        for (L2ItemInstance item : this._selllist) {
            this.writeH(item.getItem().getType1().getId());
            this.writeD(item.getObjectId());
            this.writeD(item.getDisplayId());
            this.writeQ(item.getCount());
            this.writeH(item.getItem().getType2().getId());
            this.writeH(item.isEquipped() ? 1 : 0);
            this.writeD(item.getItem().getBodyPart());
            this.writeH(item.getEnchantLevel());
            this.writeH(0);
            this.writeH(item.getCustomType2());
            this.writeQ(item.getItem().getReferencePrice() / 2);
            this.writeH(item.getAttackElementType());
            this.writeH(item.getAttackElementPower());
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                this.writeH(item.getElementDefAttr(i));
            }
            for (int op : item.getEnchantOptions()) {
                this.writeH(op);
            }
        }
    }
}

