/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.sql.impl.ClanTable;
import com.l2jserver.gameserver.instancemanager.ClanHallSiegeManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiegeInfo
extends L2GameServerPacket {
    private static final Logger LOG = LoggerFactory.getLogger(SiegeInfo.class);
    private Castle _castle;
    private ClanHall _hall;

    public SiegeInfo(Castle castle) {
        this._castle = castle;
    }

    public SiegeInfo(ClanHall hall) {
        this._hall = hall;
    }

    @Override
    protected final void writeImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        this.writeC(201);
        if (this._castle != null) {
            this.writeD(this._castle.getResidenceId());
            int ownerId = this._castle.getOwnerId();
            this.writeD(ownerId == activeChar.getClanId() && activeChar.isClanLeader() ? 1 : 0);
            this.writeD(ownerId);
            if (ownerId > 0) {
                L2Clan owner = ClanTable.getInstance().getClan(ownerId);
                if (owner != null) {
                    this.writeS(owner.getName());
                    this.writeS(owner.getLeaderName());
                    this.writeD(owner.getAllyId());
                    this.writeS(owner.getAllyName());
                } else {
                    LOG.warn("Null owner for castle: {}", (Object)this._castle.getName());
                }
            } else {
                this.writeS("");
                this.writeS("");
                this.writeD(0);
                this.writeS("");
            }
            this.writeD((int)(System.currentTimeMillis() / 1000L));
            if (!this._castle.getIsTimeRegistrationOver() && activeChar.isClanLeader() && activeChar.getClanId() == this._castle.getOwnerId()) {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(this._castle.getSiegeDate().getTimeInMillis());
                cal.set(12, 0);
                cal.set(13, 0);
                this.writeD(0);
                this.writeD(Configuration.castle().getSiegeHourList().size());
                for (int hour : Configuration.castle().getSiegeHourList()) {
                    cal.set(11, hour);
                    this.writeD((int)(cal.getTimeInMillis() / 1000L));
                }
            } else {
                this.writeD((int)(this._castle.getSiegeDate().getTimeInMillis() / 1000L));
                this.writeD(0);
            }
        } else {
            this.writeD(this._hall.getId());
            int ownerId = this._hall.getOwnerId();
            this.writeD(ownerId == activeChar.getClanId() && activeChar.isClanLeader() ? 1 : 0);
            this.writeD(ownerId);
            if (ownerId > 0) {
                L2Clan owner = ClanTable.getInstance().getClan(ownerId);
                if (owner != null) {
                    this.writeS(owner.getName());
                    this.writeS(owner.getLeaderName());
                    this.writeD(owner.getAllyId());
                    this.writeS(owner.getAllyName());
                } else {
                    LOG.warn("Null owner for siegable hall: {}", (Object)this._hall.getName());
                }
            } else {
                this.writeS("");
                this.writeS("");
                this.writeD(0);
                this.writeS("");
            }
            this.writeD((int)(Calendar.getInstance().getTimeInMillis() / 1000L));
            this.writeD((int)(ClanHallSiegeManager.getInstance().getSiegableHall(this._hall.getId()).getNextSiegeTime() / 1000L));
            this.writeD(0);
        }
    }
}

