/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.data.xml.impl.RecipeData;
import com.l2jserver.gameserver.model.L2RecipeList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.L2WarehouseItem;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.items.type.CrystalType;
import com.l2jserver.gameserver.model.items.type.EtcItemType;
import com.l2jserver.gameserver.model.items.type.ItemType2;
import com.l2jserver.gameserver.model.items.type.MaterialType;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortedWareHouseWithdrawalList
extends L2GameServerPacket {
    private static final Logger LOG = LoggerFactory.getLogger(SortedWareHouseWithdrawalList.class);
    public static final int PRIVATE = 1;
    public static final int CLAN = 2;
    public static final int CASTLE = 3;
    public static final int FREIGHT = 4;
    private final long _playerAdena;
    private List<L2WarehouseItem> _objects = new ArrayList<L2WarehouseItem>();
    private final int _whType;
    public static final byte A2Z = 1;
    public static final byte Z2A = -1;
    public static final byte GRADE = 2;
    public static final byte LEVEL = 3;
    public static final byte TYPE = 4;
    public static final byte WEAR = 5;
    public static final int MAX_SORT_LIST_ITEMS = 300;

    public SortedWareHouseWithdrawalList(L2PcInstance player, int type, WarehouseListType itemtype, byte sortorder) {
        this._whType = type;
        this._playerAdena = player.getAdena();
        if (player.getActiveWarehouse() == null) {
            LOG.warn("Error while sending withdraw request to: {}", (Object)player.getName());
            return;
        }
        switch (itemtype.ordinal()) {
            case 0: {
                this._objects = this.createWeaponList(player.getActiveWarehouse().getItems());
                break;
            }
            case 1: {
                this._objects = this.createArmorList(player.getActiveWarehouse().getItems());
                break;
            }
            case 2: {
                this._objects = this.createEtcItemList(player.getActiveWarehouse().getItems());
                break;
            }
            case 3: {
                this._objects = this.createMatList(player.getActiveWarehouse().getItems());
                break;
            }
            case 4: {
                this._objects = this.createRecipeList(player.getActiveWarehouse().getItems());
                break;
            }
            case 5: {
                this._objects = this.createAmuletList(player.getActiveWarehouse().getItems());
                break;
            }
            case 6: {
                this._objects = this.createSpellbookList(player.getActiveWarehouse().getItems());
                break;
            }
            case 9: {
                this._objects = this.createConsumableList(player.getActiveWarehouse().getItems());
                break;
            }
            case 7: {
                this._objects = this.createShotList(player.getActiveWarehouse().getItems());
                break;
            }
            case 8: {
                this._objects = this.createScrollList(player.getActiveWarehouse().getItems());
                break;
            }
            case 10: {
                this._objects = this.createSeedList(player.getActiveWarehouse().getItems());
                break;
            }
            case 14: {
                this._objects = this.createOtherList(player.getActiveWarehouse().getItems());
                break;
            }
            default: {
                this._objects = this.createAllList(player.getActiveWarehouse().getItems());
            }
        }
        try {
            switch (sortorder) {
                case -1: 
                case 1: {
                    this._objects.sort(new WarehouseItemNameComparator(sortorder));
                    break;
                }
                case 2: {
                    if (itemtype != WarehouseListType.ARMOR && itemtype != WarehouseListType.WEAPON) break;
                    this._objects.sort(new WarehouseItemNameComparator(1));
                    this._objects.sort(new WarehouseItemGradeComparator(1));
                    break;
                }
                case 3: {
                    if (itemtype != WarehouseListType.RECIPE) break;
                    this._objects.sort(new WarehouseItemNameComparator(1));
                    this._objects.sort(new WarehouseItemRecipeComparator(1));
                    break;
                }
                case 4: {
                    if (itemtype != WarehouseListType.MATERIAL) break;
                    this._objects.sort(new WarehouseItemNameComparator(1));
                    this._objects.sort(new WarehouseItemTypeComparator(1));
                    break;
                }
                case 5: {
                    if (itemtype != WarehouseListType.ARMOR) break;
                    this._objects.sort(new WarehouseItemNameComparator(1));
                    this._objects.sort(new WarehouseItemBodypartComparator(1));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte getOrder(String order) {
        if (order == null) {
            return 1;
        }
        if (order.startsWith("A2Z")) {
            return 1;
        }
        if (order.startsWith("Z2A")) {
            return -1;
        }
        if (order.startsWith("GRADE")) {
            return 2;
        }
        if (order.startsWith("TYPE")) {
            return 4;
        }
        if (order.startsWith("WEAR")) {
            return 5;
        }
        try {
            return Byte.parseByte(order);
        }
        catch (NumberFormatException ex) {
            return 1;
        }
    }

    private List<L2WarehouseItem> createWeaponList(L2ItemInstance[] _items) {
        ArrayList<L2WarehouseItem> list = new ArrayList<L2WarehouseItem>();
        for (L2ItemInstance item : _items) {
            if (!item.isWeapon() && item.getItem().getType2() != ItemType2.WEAPON && (!item.isEtcItem() || item.getItemType() != EtcItemType.ARROW) && item.getItem().getType2() != ItemType2.MONEY || list.size() >= 300) continue;
            list.add(new L2WarehouseItem(item));
        }
        return list;
    }

    private List<L2WarehouseItem> createArmorList(L2ItemInstance[] _items) {
        ArrayList<L2WarehouseItem> list = new ArrayList<L2WarehouseItem>();
        for (L2ItemInstance item : _items) {
            if (!item.isArmor() && item.getItem().getType2() != ItemType2.MONEY || list.size() >= 300) continue;
            list.add(new L2WarehouseItem(item));
        }
        return list;
    }

    private List<L2WarehouseItem> createEtcItemList(L2ItemInstance[] _items) {
        ArrayList<L2WarehouseItem> list = new ArrayList<L2WarehouseItem>();
        for (L2ItemInstance item : _items) {
            if (!item.isEtcItem() && item.getItem().getType2() != ItemType2.MONEY || list.size() >= 300) continue;
            list.add(new L2WarehouseItem(item));
        }
        return list;
    }

    private List<L2WarehouseItem> createMatList(L2ItemInstance[] _items) {
        ArrayList<L2WarehouseItem> list = new ArrayList<L2WarehouseItem>();
        for (L2ItemInstance item : _items) {
            if ((!item.isEtcItem() || item.getEtcItem().getItemType() != EtcItemType.MATERIAL) && item.getItem().getType2() != ItemType2.MONEY || list.size() >= 300) continue;
            list.add(new L2WarehouseItem(item));
        }
        return list;
    }

    private List<L2WarehouseItem> createRecipeList(L2ItemInstance[] _items) {
        ArrayList<L2WarehouseItem> list = new ArrayList<L2WarehouseItem>();
        for (L2ItemInstance item : _items) {
            if ((!item.isEtcItem() || item.getEtcItem().getItemType() != EtcItemType.RECIPE) && item.getItem().getType2() != ItemType2.MONEY || list.size() >= 300) continue;
            list.add(new L2WarehouseItem(item));
        }
        return list;
    }

    private List<L2WarehouseItem> createAmuletList(L2ItemInstance[] _items) {
        ArrayList<L2WarehouseItem> list = new ArrayList<L2WarehouseItem>();
        for (L2ItemInstance item : _items) {
            if ((!item.isEtcItem() || !item.getItemName().toUpperCase().startsWith("AMULET")) && item.getItem().getType2() != ItemType2.MONEY || list.size() >= 300) continue;
            list.add(new L2WarehouseItem(item));
        }
        return list;
    }

    private List<L2WarehouseItem> createSpellbookList(L2ItemInstance[] _items) {
        ArrayList<L2WarehouseItem> list = new ArrayList<L2WarehouseItem>();
        for (L2ItemInstance item : _items) {
            if ((!item.isEtcItem() || item.getItemName().toUpperCase().startsWith("AMULET")) && item.getItem().getType2() != ItemType2.MONEY || list.size() >= 300) continue;
            list.add(new L2WarehouseItem(item));
        }
        return list;
    }

    private List<L2WarehouseItem> createConsumableList(L2ItemInstance[] _items) {
        ArrayList<L2WarehouseItem> list = new ArrayList<L2WarehouseItem>();
        for (L2ItemInstance item : _items) {
            if ((!item.isEtcItem() || item.getEtcItem().getItemType() != EtcItemType.SCROLL && item.getEtcItem().getItemType() != EtcItemType.SHOT) && item.getItem().getType2() != ItemType2.MONEY || list.size() >= 300) continue;
            list.add(new L2WarehouseItem(item));
        }
        return list;
    }

    private List<L2WarehouseItem> createShotList(L2ItemInstance[] _items) {
        ArrayList<L2WarehouseItem> list = new ArrayList<L2WarehouseItem>();
        for (L2ItemInstance item : _items) {
            if ((!item.isEtcItem() || item.getEtcItem().getItemType() != EtcItemType.SHOT) && item.getItem().getType2() != ItemType2.MONEY || list.size() >= 300) continue;
            list.add(new L2WarehouseItem(item));
        }
        return list;
    }

    private List<L2WarehouseItem> createScrollList(L2ItemInstance[] _items) {
        ArrayList<L2WarehouseItem> list = new ArrayList<L2WarehouseItem>();
        for (L2ItemInstance item : _items) {
            if ((!item.isEtcItem() || item.getEtcItem().getItemType() != EtcItemType.SCROLL) && item.getItem().getType2() != ItemType2.MONEY || list.size() >= 300) continue;
            list.add(new L2WarehouseItem(item));
        }
        return list;
    }

    private List<L2WarehouseItem> createSeedList(L2ItemInstance[] _items) {
        ArrayList<L2WarehouseItem> list = new ArrayList<L2WarehouseItem>();
        for (L2ItemInstance item : _items) {
            if ((!item.isEtcItem() || item.getEtcItem().getItemType() != EtcItemType.SEED) && item.getItem().getType2() != ItemType2.MONEY || list.size() >= 300) continue;
            list.add(new L2WarehouseItem(item));
        }
        return list;
    }

    private List<L2WarehouseItem> createOtherList(L2ItemInstance[] _items) {
        ArrayList<L2WarehouseItem> list = new ArrayList<L2WarehouseItem>();
        for (L2ItemInstance item : _items) {
            if ((!item.isEtcItem() || item.getEtcItem().getItemType() == EtcItemType.MATERIAL || item.getEtcItem().getItemType() == EtcItemType.RECIPE || item.getEtcItem().getItemType() == EtcItemType.SCROLL || item.getEtcItem().getItemType() == EtcItemType.SHOT) && item.getItem().getType2() != ItemType2.MONEY || list.size() >= 300) continue;
            list.add(new L2WarehouseItem(item));
        }
        return list;
    }

    private List<L2WarehouseItem> createAllList(L2ItemInstance[] _items) {
        ArrayList<L2WarehouseItem> list = new ArrayList<L2WarehouseItem>();
        for (L2ItemInstance item : _items) {
            if (list.size() >= 300) continue;
            list.add(new L2WarehouseItem(item));
        }
        return list;
    }

    @Override
    protected final void writeImpl() {
        this.writeC(66);
        this.writeH(this._whType);
        this.writeQ(this._playerAdena);
        this.writeH(this._objects.size());
        for (L2WarehouseItem item : this._objects) {
            this.writeD(item.getObjectId());
            this.writeD(item.getItem().getDisplayId());
            this.writeD(item.getLocationSlot());
            this.writeQ(item.getCount());
            this.writeH(item.getItem().getType2().getId());
            this.writeH(item.getCustomType1());
            this.writeH(0);
            this.writeD(item.getItem().getBodyPart());
            this.writeH(item.getEnchantLevel());
            this.writeH(item.getCustomType2());
            if (item.isAugmented()) {
                this.writeD(item.getAugmentationId());
            } else {
                this.writeD(0);
            }
            this.writeD(item.getMana());
            this.writeD(item.getTime());
            this.writeH(item.getAttackElementType());
            this.writeH(item.getAttackElementPower());
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                this.writeH(item.getElementDefAttr(i));
            }
            for (int op : item.getEnchantOptions()) {
                this.writeH(op);
            }
            this.writeD(item.getObjectId());
        }
    }

    public static enum WarehouseListType {
        WEAPON,
        ARMOR,
        ETCITEM,
        MATERIAL,
        RECIPE,
        AMULETT,
        SPELLBOOK,
        SHOT,
        SCROLL,
        CONSUMABLE,
        SEED,
        POTION,
        QUEST,
        PET,
        OTHER,
        ALL;

    }

    private static class WarehouseItemNameComparator
    implements Comparator<L2WarehouseItem> {
        private final byte order;

        protected WarehouseItemNameComparator(byte sortOrder) {
            this.order = sortOrder;
        }

        @Override
        public int compare(L2WarehouseItem o1, L2WarehouseItem o2) {
            if (o1.getType2() == ItemType2.MONEY && o2.getType2() != ItemType2.MONEY) {
                return this.order == 1 ? -1 : 1;
            }
            if (o2.getType2() == ItemType2.MONEY && o1.getType2() != ItemType2.MONEY) {
                return this.order == 1 ? 1 : -1;
            }
            String s1 = o1.getItemName();
            String s2 = o2.getItemName();
            return this.order == 1 ? s1.compareTo(s2) : s2.compareTo(s1);
        }
    }

    private static class WarehouseItemGradeComparator
    implements Comparator<L2WarehouseItem> {
        private final byte order;

        protected WarehouseItemGradeComparator(byte sortOrder) {
            this.order = sortOrder;
        }

        @Override
        public int compare(L2WarehouseItem o1, L2WarehouseItem o2) {
            if (o1.getType2() == ItemType2.MONEY && o2.getType2() != ItemType2.MONEY) {
                return this.order == 1 ? -1 : 1;
            }
            if (o2.getType2() == ItemType2.MONEY && o1.getType2() != ItemType2.MONEY) {
                return this.order == 1 ? 1 : -1;
            }
            CrystalType i1 = o1.getItemGrade();
            CrystalType i2 = o2.getItemGrade();
            return this.order == 1 ? i1.compareTo(i2) : i2.compareTo(i1);
        }
    }

    private static class WarehouseItemRecipeComparator
    implements Comparator<L2WarehouseItem> {
        private final int order;
        private final RecipeData rd;

        protected WarehouseItemRecipeComparator(int sortOrder) {
            this.order = sortOrder;
            this.rd = RecipeData.getInstance();
        }

        @Override
        public int compare(L2WarehouseItem o1, L2WarehouseItem o2) {
            if (o1.getType2() == ItemType2.MONEY && o2.getType2() != ItemType2.MONEY) {
                return this.order == 1 ? -1 : 1;
            }
            if (o2.getType2() == ItemType2.MONEY && o1.getType2() != ItemType2.MONEY) {
                return this.order == 1 ? 1 : -1;
            }
            if (o1.isEtcItem() && o1.getItemType() == EtcItemType.RECIPE && o2.isEtcItem() && o2.getItemType() == EtcItemType.RECIPE) {
                try {
                    L2RecipeList rp1 = this.rd.getRecipeByItemId(o1.getItemId());
                    L2RecipeList rp2 = this.rd.getRecipeByItemId(o2.getItemId());
                    if (rp1 == null) {
                        return this.order == 1 ? 1 : -1;
                    }
                    if (rp2 == null) {
                        return this.order == 1 ? -1 : 1;
                    }
                    Integer i1 = rp1.getLevel();
                    Integer i2 = rp2.getLevel();
                    return this.order == 1 ? i1.compareTo(i2) : i2.compareTo(i1);
                }
                catch (Exception e) {
                    return 0;
                }
            }
            String s1 = o1.getItemName();
            String s2 = o2.getItemName();
            return this.order == 1 ? s1.compareTo(s2) : s2.compareTo(s1);
        }
    }

    private static class WarehouseItemTypeComparator
    implements Comparator<L2WarehouseItem> {
        private final byte order;

        protected WarehouseItemTypeComparator(byte sortOrder) {
            this.order = sortOrder;
        }

        @Override
        public int compare(L2WarehouseItem o1, L2WarehouseItem o2) {
            if (o1.getType2() == ItemType2.MONEY && o2.getType2() != ItemType2.MONEY) {
                return this.order == 1 ? -1 : 1;
            }
            if (o2.getType2() == ItemType2.MONEY && o1.getType2() != ItemType2.MONEY) {
                return this.order == 1 ? 1 : -1;
            }
            try {
                MaterialType i1 = o1.getItem().getMaterialType();
                MaterialType i2 = o2.getItem().getMaterialType();
                return this.order == 1 ? i1.compareTo(i2) : i2.compareTo(i1);
            }
            catch (Exception e) {
                return 0;
            }
        }
    }

    private static class WarehouseItemBodypartComparator
    implements Comparator<L2WarehouseItem> {
        private final byte order;

        protected WarehouseItemBodypartComparator(byte sortOrder) {
            this.order = sortOrder;
        }

        @Override
        public int compare(L2WarehouseItem o1, L2WarehouseItem o2) {
            if (o1.getType2() == ItemType2.MONEY && o2.getType2() != ItemType2.MONEY) {
                return this.order == 1 ? -1 : 1;
            }
            if (o2.getType2() == ItemType2.MONEY && o1.getType2() != ItemType2.MONEY) {
                return this.order == 1 ? 1 : -1;
            }
            Integer i1 = o1.getBodyPart();
            Integer i2 = o2.getBodyPart();
            return this.order == 1 ? i1.compareTo(i2) : i2.compareTo(i1);
        }
    }
}

