/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.serverpackets.AbstractItemPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WareHouseWithdrawalList
extends AbstractItemPacket {
    private static final Logger LOG = LoggerFactory.getLogger(WareHouseWithdrawalList.class);
    public static final int PRIVATE = 1;
    public static final int CLAN = 4;
    public static final int CASTLE = 3;
    public static final int FREIGHT = 1;
    private long _playerAdena;
    private L2ItemInstance[] _items;
    private int _whType;

    public WareHouseWithdrawalList(L2PcInstance player, int type) {
        if (player.getActiveWarehouse() == null) {
            LOG.warn("Error while sending withdraw request to: {}", (Object)player.getName());
            return;
        }
        this._playerAdena = player.getAdena();
        this._items = player.getActiveWarehouse().getItems();
        this._whType = type;
    }

    @Override
    protected void writeImpl() {
        this.writeC(66);
        this.writeH(this._whType);
        this.writeQ(this._playerAdena);
        this.writeH(this._items.length);
        for (L2ItemInstance item : this._items) {
            this.writeItem(item);
            this.writeD(item.getObjectId());
        }
    }
}

