/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.scripting;

import com.l2jserver.gameserver.config.Configuration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.script.ScriptException;
import org.mdkt.compiler.InMemoryJavaCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScriptEngineManager {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptEngineManager.class);
    private static final String CLASS_PATH = Configuration.server().getScriptRoot().getAbsolutePath() + System.getProperty("path.separator") + System.getProperty("java.class.path");
    private static final String MAIN = "main";
    private static final Object[] MAIN_METHOD_ARGS = new Object[]{new String[0]};
    private static final Class<?>[] ARG_MAIN = new Class[]{String[].class};

    private InMemoryJavaCompiler compiler() {
        return InMemoryJavaCompiler.newInstance().useOptions(new String[]{"-classpath", CLASS_PATH, "-g"}).ignoreWarnings();
    }

    public void executeScriptList(File list) throws Exception {
        if (Configuration.general().noQuests()) {
            return;
        }
        if (!list.isFile()) {
            throw new IllegalArgumentException("Argument must be an file containing a list of scripts to be loaded");
        }
        InMemoryJavaCompiler compiler = this.compiler();
        try (FileInputStream fis = new FileInputStream(list);
             InputStreamReader isr = new InputStreamReader(fis);
             LineNumberReader lnr = new LineNumberReader(isr);){
            String line;
            while ((line = lnr.readLine()) != null) {
                String[] parts = line.trim().split("#");
                if (parts.length <= 0 || parts[0].trim().isEmpty() || parts[0].charAt(0) == '#') continue;
                line = parts[0].trim();
                if (line.endsWith("/**")) {
                    line = line.substring(0, line.length() - 3);
                } else if (line.endsWith("/*")) {
                    line = line.substring(0, line.length() - 2);
                }
                File file = new File(Configuration.server().getScriptRoot(), line);
                if (file.isDirectory() && parts[0].endsWith("/**")) {
                    this.executeAllScriptsInDirectory(compiler, file, true);
                    continue;
                }
                if (file.isDirectory() && parts[0].endsWith("/*")) {
                    this.executeAllScriptsInDirectory(compiler, file, false);
                    continue;
                }
                if (file.isFile()) {
                    this.addSource(compiler, file);
                    continue;
                }
                LOG.warn("Failed loading: ({}) @ {}:{} - Reason: doesnt exists or is not a file.", file.getCanonicalPath(), list.getName(), lnr.getLineNumber());
            }
        }
        compiler.compileAll().forEach((k, v) -> ScriptEngineManager.runMain(v));
    }

    private void executeAllScriptsInDirectory(InMemoryJavaCompiler compiler, File dir, boolean recurseDown) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("The argument directory either doesnt exists or is not an directory.");
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory() && recurseDown) {
                if (Configuration.general().debug()) {
                    LOG.info("Entering folder: {}", (Object)file.getName());
                }
                this.executeAllScriptsInDirectory(compiler, file, recurseDown);
                continue;
            }
            if (!file.isFile()) continue;
            this.addSource(compiler, file);
        }
    }

    /*
     * Exception decompiling
     */
    public Class<?> compileScript(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void executeScript(File file) {
        Class<?> clazz = this.compileScript(file);
        ScriptEngineManager.runMain(clazz);
    }

    public void executeScript(String file) {
        this.executeScript(new File(Configuration.server().getScriptRoot(), file));
    }

    public void addSource(InMemoryJavaCompiler compiler, File file) {
        if (Configuration.general().debug()) {
            LOG.info("Loading Script: {}", (Object)file.getAbsolutePath());
        }
        try (FileInputStream fis = new FileInputStream(file);
             InputStreamReader isr = new InputStreamReader(fis);
             BufferedReader reader = new BufferedReader(isr);){
            compiler.addSource(ScriptEngineManager.getClassForFile(file), ScriptEngineManager.readerToString(reader));
        }
        catch (Exception ex) {
            LOG.warn("Error executing script!", ex);
        }
    }

    private static String getClassForFile(File script) {
        String scpPath;
        String path = script.getAbsolutePath();
        if (path.startsWith(scpPath = Configuration.server().getScriptRoot().getAbsolutePath())) {
            int idx = path.lastIndexOf(46);
            return path.substring(scpPath.length() + 1, idx).replace('/', '.').replace('\\', '.');
        }
        return null;
    }

    private static void runMain(Class<?> clazz) {
        Method mainMethod = ScriptEngineManager.findMethod(clazz, MAIN, ARG_MAIN);
        if (mainMethod == null) {
            LOG.warn("Unable to find main method in class {}!", (Object)clazz);
            return;
        }
        try {
            mainMethod.invoke(null, MAIN_METHOD_ARGS);
        }
        catch (Exception ex) {
            LOG.error("Error loading script {}!", (Object)clazz);
        }
    }

    private static String readerToString(Reader reader) throws ScriptException {
        String string;
        BufferedReader in = new BufferedReader(reader);
        try {
            String line;
            StringBuilder result = new StringBuilder();
            while ((line = in.readLine()) != null) {
                result.append(line).append(System.lineSeparator());
            }
            string = result.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new ScriptException(ex);
            }
        }
        in.close();
        return string;
    }

    private static Method findMethod(Class<?> clazz, String methodName, Class<?>[] args) {
        try {
            Method mainMethod = clazz.getMethod(methodName, args);
            int modifiers = mainMethod.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers)) {
                return mainMethod;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public static ScriptEngineManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final ScriptEngineManager INSTANCE = new ScriptEngineManager();

        private SingletonHolder() {
        }
    }
}

