/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.taskmanager;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2CubicInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.AutoAttackStop;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttackStanceTaskManager {
    private static final Logger LOG = LoggerFactory.getLogger(AttackStanceTaskManager.class);
    private static final Map<L2Character, Long> _attackStanceTasks = new ConcurrentHashMap<L2Character, Long>();

    protected AttackStanceTaskManager() {
        ThreadPoolManager.getInstance().scheduleAiAtFixedRate(new FightModeScheduler(), 0L, 1000L);
    }

    public void addAttackStanceTask(L2Character actor) {
        if (actor != null) {
            if (actor.isPlayable()) {
                L2PcInstance player = actor.getActingPlayer();
                for (L2CubicInstance cubic : player.getCubics().values()) {
                    if (cubic.getId() == 3) continue;
                    cubic.doAction();
                }
            }
            _attackStanceTasks.put(actor, System.currentTimeMillis());
        }
    }

    public void removeAttackStanceTask(L2Character actor) {
        if (actor != null) {
            if (actor.isSummon()) {
                actor = actor.getActingPlayer();
            }
            _attackStanceTasks.remove(actor);
        }
    }

    public boolean hasAttackStanceTask(L2Character actor) {
        if (actor != null) {
            if (actor.isSummon()) {
                actor = actor.getActingPlayer();
            }
            return _attackStanceTasks.containsKey(actor);
        }
        return false;
    }

    public static AttackStanceTaskManager getInstance() {
        return SingletonHolder._instance;
    }

    protected static class FightModeScheduler
    implements Runnable {
        protected FightModeScheduler() {
        }

        @Override
        public void run() {
            long current = System.currentTimeMillis();
            try {
                Iterator<Map.Entry<L2Character, Long>> iter = _attackStanceTasks.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<L2Character, Long> e = iter.next();
                    if (current - e.getValue() <= 15000L) continue;
                    L2Character actor = e.getKey();
                    if (actor != null) {
                        actor.broadcastPacket(new AutoAttackStop(actor.getObjectId()));
                        actor.getAI().setAutoAttacking(false);
                        if (actor.isPlayer() && actor.hasSummon()) {
                            actor.getSummon().broadcastPacket(new AutoAttackStop(actor.getSummon().getObjectId()));
                        }
                    }
                    iter.remove();
                }
            }
            catch (Exception e) {
                LOG.warn("Error in FightModeScheduler: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private static class SingletonHolder {
        protected static final AttackStanceTaskManager _instance = new AttackStanceTaskManager();

        private SingletonHolder() {
        }
    }
}

