/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.taskmanager.tasks;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.instancemanager.MailManager;
import com.l2jserver.gameserver.model.entity.Message;
import com.l2jserver.gameserver.taskmanager.Task;
import com.l2jserver.gameserver.taskmanager.TaskManager;
import com.l2jserver.gameserver.taskmanager.TaskTypes;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskBirthday
extends Task {
    private static final Logger LOG = LoggerFactory.getLogger(TaskBirthday.class);
    private static final String NAME = "birthday";
    private static final String SELECT_PENDING_BIRTHDAY_GIFTS = "SELECT charId, char_name, createDate, (YEAR(NOW()) - YEAR(createDate)) AS age FROM characters WHERE (YEAR(NOW()) - YEAR(createDate) > 0) AND ((DATE_ADD(createDate, INTERVAL (YEAR(NOW()) - YEAR(createDate)) YEAR)) BETWEEN FROM_UNIXTIME(?) AND NOW())";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void onTimeElapsed(TaskManager.ExecutedTask task) {
        int birthdayGiftCount = this.giveBirthdayGifts(task.getLastActivation());
        LOG.info("{} gifts sent.", (Object)birthdayGiftCount);
    }

    private int giveBirthdayGifts(long lastActivation) {
        int birthdayGiftCount = 0;
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(SELECT_PENDING_BIRTHDAY_GIFTS);){
            ps.setLong(1, TimeUnit.SECONDS.convert(lastActivation, TimeUnit.MILLISECONDS));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String text = Configuration.general().getBirthdayMailText();
                    text = text.replaceAll("$c1", rs.getString("char_name"));
                    text = text.replaceAll("$s1", Integer.toString(rs.getInt("age")));
                    Message msg = new Message(rs.getInt("charId"), Configuration.general().getBirthdayMailSubject(), text, Message.SendBySystem.ALEGRIA);
                    msg.createAttachments().addItem("Birthday", Configuration.general().getBirthdayGift(), 1L, null, null);
                    MailManager.getInstance().sendMessage(msg);
                    ++birthdayGiftCount;
                }
            }
        }
        catch (Exception ex) {
            LOG.warn("There has been an error sending gifts!", ex);
        }
        return birthdayGiftCount;
    }

    @Override
    public void initializate() {
        TaskManager.addUniqueTask(NAME, TaskTypes.TYPE_GLOBAL_TASK, "1", "06:30:00", "");
    }
}

