/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.taskmanager.tasks;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.sql.impl.ClanTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ClanMember;
import com.l2jserver.gameserver.taskmanager.Task;
import com.l2jserver.gameserver.taskmanager.TaskManager;
import com.l2jserver.gameserver.taskmanager.TaskTypes;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskClanLeaderApply
extends Task {
    private static final Logger LOG = LoggerFactory.getLogger(TaskClanLeaderApply.class);
    private static final String NAME = "clanleaderapply";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void onTimeElapsed(TaskManager.ExecutedTask task) {
        Calendar cal = Calendar.getInstance();
        if (cal.get(7) == Configuration.character().getClanLeaderDateChange()) {
            for (L2Clan clan : ClanTable.getInstance().getClans()) {
                L2ClanMember member;
                if (clan.getNewLeaderId() == 0 || (member = clan.getClanMember(clan.getNewLeaderId())) == null) continue;
                clan.setNewLeader(member);
            }
            LOG.info("Task launched.");
        }
    }

    @Override
    public void initializate() {
        TaskManager.addUniqueTask(NAME, TaskTypes.TYPE_GLOBAL_TASK, "1", Configuration.character().getClanLeaderHourChange(), "");
    }
}

