/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.taskmanager.tasks;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.scripting.ScriptEngineManager;
import com.l2jserver.gameserver.taskmanager.Task;
import com.l2jserver.gameserver.taskmanager.TaskManager;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskScript
extends Task {
    private static final Logger LOG = LoggerFactory.getLogger(TaskScript.class);
    private static final String NAME = "script";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void onTimeElapsed(TaskManager.ExecutedTask task) {
        File file = new File(Configuration.server().getScriptRoot(), "com/l2jserver/datapack/cron/" + task.getParams()[2]);
        if (!file.isFile()) {
            LOG.warn("File not found {}!", (Object)task.getParams()[2]);
            return;
        }
        try {
            ScriptEngineManager.getInstance().compileScript(file);
        }
        catch (Exception ex) {
            LOG.warn("Failed loading {}!", (Object)task.getParams()[2]);
        }
    }
}

