/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.instancemanager.PunishmentManager;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.punishment.PunishmentAffect;
import com.l2jserver.gameserver.model.punishment.PunishmentTask;
import com.l2jserver.gameserver.model.punishment.PunishmentType;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.util.StringUtil;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FloodProtectorAction {
    private static final Logger LOG = LoggerFactory.getLogger(FloodProtectorAction.class);
    private final L2GameClient client;
    private final String type;
    private final int interval;
    private final boolean logFlooding;
    private final int punishmentLimit;
    private final String punishmentType;
    private final int punishmentTime;
    private volatile int nextGameTick = GameTimeController.getInstance().getGameTicks();
    private final AtomicInteger count = new AtomicInteger(0);
    private boolean logged;
    private volatile boolean punishmentInProgress;

    public FloodProtectorAction(L2GameClient client, String configName) {
        this.client = client;
        this.type = configName;
        this.interval = Integer.parseInt(Configuration.floodProtector().getProperty(configName + "Interval"));
        this.logFlooding = Boolean.parseBoolean(Configuration.floodProtector().getProperty(configName + "LogFlooding"));
        this.punishmentLimit = Integer.parseInt(Configuration.floodProtector().getProperty(configName + "PunishmentLimit"));
        this.punishmentType = Configuration.floodProtector().getProperty(configName + "PunishmentType");
        this.punishmentTime = Integer.parseInt(Configuration.floodProtector().getProperty(configName + "PunishmentTime")) * 60000;
    }

    public boolean tryPerformAction(String command) {
        int curTick = GameTimeController.getInstance().getGameTicks();
        if (this.client.getActiveChar() != null && this.client.getActiveChar().canOverrideCond(PcCondOverride.FLOOD_CONDITIONS)) {
            return true;
        }
        if (curTick < this.nextGameTick || this.punishmentInProgress) {
            if (this.logFlooding && !this.logged && LOG.isWarnEnabled()) {
                this.log(" called command ", command, " ~", String.valueOf((this.interval - (this.nextGameTick - curTick)) * 100), " ms after previous command");
                this.logged = true;
            }
            this.count.incrementAndGet();
            if (!this.punishmentInProgress && this.punishmentLimit > 0 && this.count.get() >= this.punishmentLimit && this.punishmentType != null) {
                this.punishmentInProgress = true;
                switch (this.punishmentType) {
                    case "kick": {
                        this.kickPlayer();
                        break;
                    }
                    case "ban": {
                        this.banAccount();
                        break;
                    }
                    case "jail": {
                        this.jailChar();
                    }
                }
                this.punishmentInProgress = false;
            }
            return false;
        }
        if (this.count.get() > 0 && this.logFlooding && LOG.isWarnEnabled()) {
            this.log(" issued ", String.valueOf(this.count), " extra requests within ~", String.valueOf(this.interval * 100), " ms");
        }
        this.nextGameTick = curTick + this.interval;
        this.logged = false;
        this.count.set(0);
        return true;
    }

    private void kickPlayer() {
        if (this.client.getActiveChar() != null) {
            this.client.getActiveChar().logout(false);
        } else {
            this.client.closeNow();
        }
        if (LOG.isWarnEnabled()) {
            this.log("kicked for flooding");
        }
    }

    private void banAccount() {
        PunishmentManager.getInstance().startPunishment(new PunishmentTask(this.client.getAccountName(), PunishmentAffect.ACCOUNT, PunishmentType.BAN, System.currentTimeMillis() + (long)this.punishmentTime, "", this.getClass().getSimpleName()));
        if (LOG.isWarnEnabled()) {
            this.log(new String[]{" banned for flooding ", this.punishmentTime <= 0 ? "forever" : "for " + this.punishmentTime / 60000 + " mins"});
        }
    }

    private void jailChar() {
        if (this.client.getActiveChar() != null) {
            int charId = this.client.getActiveChar().getObjectId();
            if (charId > 0) {
                PunishmentManager.getInstance().startPunishment(new PunishmentTask(charId, PunishmentAffect.CHARACTER, PunishmentType.JAIL, System.currentTimeMillis() + (long)this.punishmentTime, "", this.getClass().getSimpleName()));
            }
            if (LOG.isWarnEnabled()) {
                this.log(new String[]{" jailed for flooding ", this.punishmentTime <= 0 ? "forever" : "for " + this.punishmentTime / 60000 + " mins"});
            }
        }
    }

    private void log(String ... lines) {
        StringBuilder output = StringUtil.startAppend(100, this.type, ": ");
        String address = null;
        try {
            if (!this.client.isDetached()) {
                address = this.client.getConnection().getInetAddress().getHostAddress();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (this.client.getState()) {
            case JOINING: 
            case IN_GAME: {
                if (this.client.getActiveChar() == null) break;
                StringUtil.append(output, this.client.getActiveChar().getName());
                StringUtil.append(output, "(", String.valueOf(this.client.getActiveChar().getObjectId()), ") ");
                break;
            }
            case AUTHED: {
                if (this.client.getAccountName() == null) break;
                StringUtil.append(output, this.client.getAccountName(), " ");
                break;
            }
            case CONNECTED: {
                if (address == null) break;
                StringUtil.append(output, address);
                break;
            }
            default: {
                throw new IllegalStateException("Missing state on switch");
            }
        }
        StringUtil.append(output, lines);
        LOG.warn(output.toString());
    }
}

