/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.geodriver;

import com.l2jserver.geodriver.Region;
import com.l2jserver.geodriver.regions.NormalRegion;
import com.l2jserver.geodriver.regions.NullRegion;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class GeoDriver {
    private static final int WORLD_MIN_X = -655360;
    private static final int WORLD_MAX_X = 393215;
    private static final int WORLD_MIN_Y = -589824;
    private static final int WORLD_MAX_Y = 458751;
    public static final int GEO_REGIONS_X = 32;
    public static final int GEO_REGIONS_Y = 32;
    public static final int GEO_REGIONS = 1024;
    public static final int GEO_BLOCKS_X = 8192;
    public static final int GEO_BLOCKS_Y = 8192;
    public static final int GEO_BLOCKS = 0x4000000;
    public static final int GEO_CELLS_X = 65536;
    public static final int GEO_CELLS_Y = 65536;
    private final AtomicReferenceArray<Region> _regions = new AtomicReferenceArray(1024);

    public GeoDriver() {
        for (int i = 0; i < this._regions.length(); ++i) {
            this._regions.set(i, NullRegion.INSTANCE);
        }
    }

    private void checkGeoX(int geoX) {
        if (geoX < 0 || geoX >= 65536) {
            throw new IllegalArgumentException();
        }
    }

    private void checkGeoY(int geoY) {
        if (geoY < 0 || geoY >= 65536) {
            throw new IllegalArgumentException();
        }
    }

    private Region getRegion(int geoX, int geoY) {
        this.checkGeoX(geoX);
        this.checkGeoY(geoY);
        return this._regions.get(geoX / 2048 * 32 + geoY / 2048);
    }

    public void loadRegion(Path filePath, int regionX, int regionY) throws IOException {
        int regionOffset = regionX * 32 + regionY;
        try (RandomAccessFile raf = new RandomAccessFile(filePath.toFile(), "r");){
            this._regions.set(regionOffset, new NormalRegion(raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, raf.length()).order(ByteOrder.LITTLE_ENDIAN)));
        }
    }

    public void unloadRegion(int regionX, int regionY) {
        this._regions.set(regionX * 32 + regionY, NullRegion.INSTANCE);
    }

    public boolean hasGeoPos(int geoX, int geoY) {
        return this.getRegion(geoX, geoY).hasGeo();
    }

    public boolean checkNearestNswe(int geoX, int geoY, int worldZ, int nswe) {
        return this.getRegion(geoX, geoY).checkNearestNswe(geoX, geoY, worldZ, nswe);
    }

    public int getNearestZ(int geoX, int geoY, int worldZ) {
        return this.getRegion(geoX, geoY).getNearestZ(geoX, geoY, worldZ);
    }

    public int getNextLowerZ(int geoX, int geoY, int worldZ) {
        return this.getRegion(geoX, geoY).getNextLowerZ(geoX, geoY, worldZ);
    }

    public int getNextHigherZ(int geoX, int geoY, int worldZ) {
        return this.getRegion(geoX, geoY).getNextHigherZ(geoX, geoY, worldZ);
    }

    public int getGeoX(int worldX) {
        if (worldX < -655360 || worldX > 393215) {
            throw new IllegalArgumentException();
        }
        return (worldX - -655360) / 16;
    }

    public int getGeoY(int worldY) {
        if (worldY < -589824 || worldY > 458751) {
            throw new IllegalArgumentException();
        }
        return (worldY - -589824) / 16;
    }

    public int getWorldX(int geoX) {
        this.checkGeoX(geoX);
        return geoX * 16 + -655360 + 8;
    }

    public int getWorldY(int geoY) {
        this.checkGeoY(geoY);
        return geoY * 16 + -589824 + 8;
    }
}

