/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.geodriver.blocks;

import com.l2jserver.geodriver.Block;
import java.nio.ByteBuffer;

public final class ComplexBlock
implements Block {
    private final short[] _data = new short[64];

    public ComplexBlock(ByteBuffer bb) {
        for (int cellOffset = 0; cellOffset < 64; ++cellOffset) {
            this._data[cellOffset] = bb.getShort();
        }
    }

    private short _getCellData(int geoX, int geoY) {
        return this._data[geoX % 8 * 8 + geoY % 8];
    }

    private byte _getCellNSWE(int geoX, int geoY) {
        return (byte)(this._getCellData(geoX, geoY) & 0xF);
    }

    private int _getCellHeight(int geoX, int geoY) {
        short height = (short)(this._getCellData(geoX, geoY) & 0xFFF0);
        return height >> 1;
    }

    @Override
    public boolean checkNearestNswe(int geoX, int geoY, int worldZ, int nswe) {
        return (this._getCellNSWE(geoX, geoY) & nswe) == nswe;
    }

    @Override
    public int getNearestZ(int geoX, int geoY, int worldZ) {
        return this._getCellHeight(geoX, geoY);
    }

    @Override
    public int getNextLowerZ(int geoX, int geoY, int worldZ) {
        int cellHeight = this._getCellHeight(geoX, geoY);
        return Math.min(cellHeight, worldZ);
    }

    @Override
    public int getNextHigherZ(int geoX, int geoY, int worldZ) {
        int cellHeight = this._getCellHeight(geoX, geoY);
        return Math.max(cellHeight, worldZ);
    }
}

