/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.commons.util;

import java.util.Arrays;

public class HexUtils {
    private static final char[] NIBBLE_CHAR_LOOKUP = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final char[] NEW_LINE_CHARS = System.lineSeparator().toCharArray();
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private static final int HEX_ED_BPL = 16;
    private static final int HEX_ED_CPB = 2;
    private static final int HEX_ED_CPL = 58 + NEW_LINE_CHARS.length;

    public static char[] b2HexChars(byte data) {
        return HexUtils.b2HexChars(data, null, 0);
    }

    public static char[] b2HexChars(byte data, char[] dstHexChars, int dstOffset) {
        if (dstHexChars == null) {
            dstHexChars = new char[2];
            dstOffset = 0;
        }
        dstHexChars[dstOffset] = NIBBLE_CHAR_LOOKUP[(data & 0xF0) >> 4];
        dstHexChars[dstOffset + 1] = NIBBLE_CHAR_LOOKUP[data & 0xF];
        return dstHexChars;
    }

    public static char[] int2HexChars(int data) {
        return HexUtils.int2HexChars(data, new char[8], 0);
    }

    public static char[] int2HexChars(int data, char[] dstHexChars, int dstOffset) {
        if (dstHexChars == null) {
            dstHexChars = new char[8];
            dstOffset = 0;
        }
        HexUtils.b2HexChars((byte)((data & 0xFF000000) >> 24), dstHexChars, dstOffset);
        HexUtils.b2HexChars((byte)((data & 0xFF0000) >> 16), dstHexChars, dstOffset + 2);
        HexUtils.b2HexChars((byte)((data & 0xFF00) >> 8), dstHexChars, dstOffset + 4);
        HexUtils.b2HexChars((byte)(data & 0xFF), dstHexChars, dstOffset + 6);
        return dstHexChars;
    }

    public static char[] bArr2HexChars(byte[] data, int offset, int len) {
        return HexUtils.bArr2HexChars(data, offset, len, null, 0);
    }

    public static char[] bArr2HexChars(byte[] data, int offset, int len, char[] dstHexChars, int dstOffset) {
        if (dstHexChars == null) {
            dstHexChars = new char[len * 2];
            dstOffset = 0;
        }
        int dataIdx = offset;
        int charsIdx = dstOffset;
        while (dataIdx < len + offset) {
            dstHexChars[charsIdx] = NIBBLE_CHAR_LOOKUP[(data[dataIdx] & 0xF0) >> 4];
            dstHexChars[++charsIdx] = NIBBLE_CHAR_LOOKUP[data[dataIdx] & 0xF];
            ++dataIdx;
            ++charsIdx;
        }
        return dstHexChars;
    }

    public static char[] bArr2AsciiChars(byte[] data, int offset, int len) {
        return HexUtils.bArr2AsciiChars(data, offset, len, new char[len], 0);
    }

    public static char[] bArr2AsciiChars(byte[] data, int offset, int len, char[] dstAsciiChars, int dstOffset) {
        if (dstAsciiChars == null) {
            dstAsciiChars = new char[len];
            dstOffset = 0;
        }
        int dataIdx = offset;
        int charsIdx = dstOffset;
        while (dataIdx < len + offset) {
            dstAsciiChars[charsIdx] = data[dataIdx] > 31 && data[dataIdx] < 128 ? (int)data[dataIdx] : 46;
            ++dataIdx;
            ++charsIdx;
        }
        return dstAsciiChars;
    }

    public static char[] bArr2HexEdChars(byte[] data, int len) {
        char[] textData;
        int numLines;
        if (len == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        int lenBplMod = len % 16;
        if (lenBplMod == 0) {
            numLines = len / 16;
            textData = new char[HEX_ED_CPL * numLines - NEW_LINE_CHARS.length];
        } else {
            numLines = len / 16 + 1;
            textData = new char[HEX_ED_CPL * numLines - (16 - lenBplMod) - NEW_LINE_CHARS.length];
        }
        for (int i = 0; i < numLines; ++i) {
            int dataOffset = i * 16;
            int dataLen = Math.min(len - dataOffset, 16);
            int lineStart = i * HEX_ED_CPL;
            int lineHexDataStart = lineStart + 9;
            int lineAsciiDataStart = lineHexDataStart + 32 + 1;
            HexUtils.int2HexChars(dataOffset, textData, lineStart);
            textData[lineHexDataStart - 1] = 32;
            HexUtils.bArr2HexChars(data, dataOffset, dataLen, textData, lineHexDataStart);
            HexUtils.bArr2AsciiChars(data, dataOffset, dataLen, textData, lineAsciiDataStart);
            if (i < numLines - 1) {
                textData[lineAsciiDataStart - 1] = 32;
                System.arraycopy(NEW_LINE_CHARS, 0, textData, lineAsciiDataStart + 16, NEW_LINE_CHARS.length);
                continue;
            }
            if (dataLen < 16) {
                int lineHexDataEnd = lineHexDataStart + dataLen * 2;
                Arrays.fill(textData, lineHexDataEnd, lineHexDataEnd + (16 - dataLen) * 2 + 1, ' ');
                continue;
            }
            textData[lineAsciiDataStart - 1] = 32;
        }
        return textData;
    }
}

