/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.geodriver.blocks;

import com.l2jserver.geodriver.Block;
import java.nio.ByteBuffer;

public class MultilayerBlock
implements Block {
    private final byte[] _data;

    public MultilayerBlock(ByteBuffer bb) {
        int start = bb.position();
        for (int blockCellOffset = 0; blockCellOffset < 64; ++blockCellOffset) {
            byte nLayers = bb.get();
            if (nLayers <= 0 || nLayers > 125) {
                throw new RuntimeException("L2JGeoDriver: Geo file corrupted! Invalid layers count!");
            }
            bb.position(bb.position() + nLayers * 2);
        }
        this._data = new byte[bb.position() - start];
        bb.position(start);
        bb.get(this._data);
    }

    private short _getNearestLayer(int geoX, int geoY, int worldZ) {
        int startOffset = this._getCellDataOffset(geoX, geoY);
        byte nLayers = this._data[startOffset];
        int endOffset = startOffset + 1 + nLayers * 2;
        int nearestDZ = 0;
        short nearestData = 0;
        for (int offset = startOffset + 1; offset < endOffset; offset += 2) {
            short layerData = this._extractLayerData(offset);
            int layerZ = this._extractLayerHeight(layerData);
            if (layerZ == worldZ) {
                return layerData;
            }
            int layerDZ = Math.abs(layerZ - worldZ);
            if (offset != startOffset + 1 && layerDZ >= nearestDZ) continue;
            nearestDZ = layerDZ;
            nearestData = layerData;
        }
        return nearestData;
    }

    private int _getCellDataOffset(int geoX, int geoY) {
        int cellLocalOffset = geoX % 8 * 8 + geoY % 8;
        int cellDataOffset = 0;
        for (int i = 0; i < cellLocalOffset; ++i) {
            cellDataOffset += 1 + this._data[cellDataOffset] * 2;
        }
        return cellDataOffset;
    }

    private short _extractLayerData(int dataOffset) {
        return (short)(this._data[dataOffset] & 0xFF | this._data[dataOffset + 1] << 8);
    }

    private int _getNearestNSWE(int geoX, int geoY, int worldZ) {
        return this._extractLayerNswe(this._getNearestLayer(geoX, geoY, worldZ));
    }

    private int _extractLayerNswe(short layer) {
        return (byte)(layer & 0xF);
    }

    private int _extractLayerHeight(short layer) {
        layer = (short)(layer & 0xFFF0);
        return layer >> 1;
    }

    @Override
    public boolean checkNearestNswe(int geoX, int geoY, int worldZ, int nswe) {
        return (this._getNearestNSWE(geoX, geoY, worldZ) & nswe) == nswe;
    }

    @Override
    public int getNearestZ(int geoX, int geoY, int worldZ) {
        return this._extractLayerHeight(this._getNearestLayer(geoX, geoY, worldZ));
    }

    @Override
    public int getNextLowerZ(int geoX, int geoY, int worldZ) {
        int startOffset = this._getCellDataOffset(geoX, geoY);
        byte nLayers = this._data[startOffset];
        int endOffset = startOffset + 1 + nLayers * 2;
        int lowerZ = Integer.MIN_VALUE;
        for (int offset = startOffset + 1; offset < endOffset; offset += 2) {
            short layerData = this._extractLayerData(offset);
            int layerZ = this._extractLayerHeight(layerData);
            if (layerZ == worldZ) {
                return layerZ;
            }
            if (layerZ >= worldZ || layerZ <= lowerZ) continue;
            lowerZ = layerZ;
        }
        return lowerZ == Integer.MIN_VALUE ? worldZ : lowerZ;
    }

    @Override
    public int getNextHigherZ(int geoX, int geoY, int worldZ) {
        int startOffset = this._getCellDataOffset(geoX, geoY);
        byte nLayers = this._data[startOffset];
        int endOffset = startOffset + 1 + nLayers * 2;
        int higherZ = Integer.MAX_VALUE;
        for (int offset = startOffset + 1; offset < endOffset; offset += 2) {
            short layerData = this._extractLayerData(offset);
            int layerZ = this._extractLayerHeight(layerData);
            if (layerZ == worldZ) {
                return layerZ;
            }
            if (layerZ <= worldZ || layerZ >= higherZ) continue;
            higherZ = layerZ;
        }
        return higherZ == Integer.MAX_VALUE ? worldZ : higherZ;
    }
}

