/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.mmocore;

import com.l2jserver.mmocore.AcceptFilter;
import com.l2jserver.mmocore.ClientFactory;
import com.l2jserver.mmocore.MMOClient;
import com.l2jserver.mmocore.MMOConnection;
import com.l2jserver.mmocore.MMOExecutor;
import com.l2jserver.mmocore.NioNetStackList;
import com.l2jserver.mmocore.NioNetStringBuffer;
import com.l2jserver.mmocore.PacketHandler;
import com.l2jserver.mmocore.ReceivablePacket;
import com.l2jserver.mmocore.SelectorConfig;
import com.l2jserver.mmocore.SendablePacket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class SelectorThread<T extends MMOClient<?>>
extends Thread {
    private static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private static final int HEADER_SIZE = 2;
    private final Selector _selector;
    private final PacketHandler<T> _packetHandler;
    private final MMOExecutor<T> _executor;
    private final ClientFactory<T> _clientFactory;
    private final AcceptFilter _acceptFilter;
    private final int HELPER_BUFFER_SIZE;
    private final int HELPER_BUFFER_COUNT;
    private final int MAX_SEND_PER_PASS;
    private final int MAX_READ_PER_PASS;
    private final long SLEEP_TIME;
    public boolean TCP_NODELAY;
    private final ByteBuffer DIRECT_WRITE_BUFFER;
    private final ByteBuffer WRITE_BUFFER;
    private final ByteBuffer READ_BUFFER;
    private final NioNetStringBuffer STRING_BUFFER;
    private final Queue<ByteBuffer> _bufferPool;
    private final NioNetStackList<MMOConnection<T>> _pendingClose;
    private boolean _shutdown;

    public SelectorThread(SelectorConfig sc, MMOExecutor<T> executor, PacketHandler<T> packetHandler, ClientFactory<T> clientFactory, AcceptFilter acceptFilter) throws IOException {
        super.setName("SelectorThread-" + super.getId());
        this.HELPER_BUFFER_SIZE = sc.HELPER_BUFFER_SIZE;
        this.HELPER_BUFFER_COUNT = sc.HELPER_BUFFER_COUNT;
        this.MAX_SEND_PER_PASS = sc.MAX_SEND_PER_PASS;
        this.MAX_READ_PER_PASS = sc.MAX_READ_PER_PASS;
        this.SLEEP_TIME = sc.SLEEP_TIME;
        this.TCP_NODELAY = sc.TCP_NODELAY;
        this.DIRECT_WRITE_BUFFER = ByteBuffer.allocateDirect(sc.WRITE_BUFFER_SIZE).order(BYTE_ORDER);
        this.WRITE_BUFFER = ByteBuffer.wrap(new byte[sc.WRITE_BUFFER_SIZE]).order(BYTE_ORDER);
        this.READ_BUFFER = ByteBuffer.wrap(new byte[sc.READ_BUFFER_SIZE]).order(BYTE_ORDER);
        this.STRING_BUFFER = new NioNetStringBuffer(65536);
        this._pendingClose = new NioNetStackList();
        this._bufferPool = new ConcurrentLinkedQueue<ByteBuffer>();
        for (int i = 0; i < this.HELPER_BUFFER_COUNT; ++i) {
            this._bufferPool.add(ByteBuffer.wrap(new byte[this.HELPER_BUFFER_SIZE]).order(BYTE_ORDER));
        }
        this._acceptFilter = acceptFilter;
        this._packetHandler = packetHandler;
        this._clientFactory = clientFactory;
        this._executor = executor;
        this._selector = Selector.open();
    }

    public final void openServerSocket(InetAddress address, int tcpPort) throws IOException {
        ServerSocketChannel selectable = ServerSocketChannel.open();
        selectable.configureBlocking(false);
        ServerSocket ss = selectable.socket();
        if (address == null) {
            ss.bind(new InetSocketAddress(tcpPort));
        } else {
            ss.bind(new InetSocketAddress(address, tcpPort));
        }
        selectable.register(this._selector, 16);
    }

    final ByteBuffer getPooledBuffer() {
        if (this._bufferPool.isEmpty()) {
            return ByteBuffer.wrap(new byte[this.HELPER_BUFFER_SIZE]).order(BYTE_ORDER);
        }
        return this._bufferPool.remove();
    }

    final void recycleBuffer(ByteBuffer buf) {
        if (this._bufferPool.size() < this.HELPER_BUFFER_COUNT) {
            buf.clear();
            this._bufferPool.add(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        int selectedKeysCount = 0;
        while (!this._shutdown) {
            Object selectedKeys;
            try {
                selectedKeysCount = this._selector.selectNow();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (selectedKeysCount > 0) {
                selectedKeys = this._selector.selectedKeys().iterator();
                while (selectedKeys.hasNext()) {
                    SelectionKey key = (SelectionKey)selectedKeys.next();
                    selectedKeys.remove();
                    MMOConnection con = (MMOConnection)key.attachment();
                    switch (key.readyOps()) {
                        case 8: {
                            this.finishConnection(key, con);
                            break;
                        }
                        case 16: {
                            this.acceptConnection(key);
                            break;
                        }
                        case 1: {
                            this.readPacket(key, con);
                            break;
                        }
                        case 4: {
                            this.writePacket(key, con);
                            break;
                        }
                        case 5: {
                            this.writePacket(key, con);
                            if (!key.isValid()) break;
                            this.readPacket(key, con);
                        }
                    }
                }
            }
            selectedKeys = this._pendingClose;
            synchronized (selectedKeys) {
                while (!this._pendingClose.isEmpty()) {
                    try {
                        MMOConnection<T> con = this._pendingClose.removeFirst();
                        this.writeClosePacket(con);
                        this.closeConnectionImpl(con.getSelectionKey(), con);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            try {
                Thread.sleep(this.SLEEP_TIME);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.closeSelectorThread();
    }

    private void finishConnection(SelectionKey key, MMOConnection<T> con) {
        try {
            ((SocketChannel)key.channel()).finishConnect();
        }
        catch (IOException e) {
            ((MMOClient)con.getClient()).onForcedDisconnection();
            this.closeConnectionImpl(key, con);
        }
        if (key.isValid()) {
            key.interestOps(key.interestOps() | 1);
            key.interestOps(key.interestOps() & 0xFFFFFFF7);
        }
    }

    private void acceptConnection(SelectionKey key) {
        ServerSocketChannel ssc = (ServerSocketChannel)key.channel();
        try {
            SocketChannel sc;
            while ((sc = ssc.accept()) != null) {
                if (this._acceptFilter == null || this._acceptFilter.accept(sc)) {
                    sc.configureBlocking(false);
                    SelectionKey clientKey = sc.register(this._selector, 1);
                    MMOConnection<T> con = new MMOConnection<T>(this, sc.socket(), clientKey, this.TCP_NODELAY);
                    con.setClient(this._clientFactory.create(con));
                    clientKey.attach(con);
                    continue;
                }
                sc.socket().close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readPacket(SelectionKey key, MMOConnection<T> con) {
        if (!con.isClosed()) {
            ByteBuffer buf = con.getReadBuffer();
            if (buf == null) {
                buf = this.READ_BUFFER;
            }
            if (buf.position() == buf.limit()) {
                System.exit(0);
            }
            int result = -2;
            try {
                result = con.read(buf);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (result > 0) {
                buf.flip();
                T client = con.getClient();
                for (int i = 0; i < this.MAX_READ_PER_PASS; ++i) {
                    if (this.tryReadPacket(key, client, buf, con)) continue;
                    return;
                }
                if (buf.remaining() > 0) {
                    if (buf == this.READ_BUFFER) {
                        this.allocateReadBuffer(con);
                    } else {
                        buf.compact();
                    }
                }
            } else {
                switch (result) {
                    case -1: 
                    case 0: {
                        this.closeConnectionImpl(key, con);
                        break;
                    }
                    case -2: {
                        ((MMOClient)con.getClient()).onForcedDisconnection();
                        this.closeConnectionImpl(key, con);
                    }
                }
            }
        }
    }

    private boolean tryReadPacket(SelectionKey key, T client, ByteBuffer buf, MMOConnection<T> con) {
        switch (buf.remaining()) {
            case 0: {
                return false;
            }
            case 1: {
                key.interestOps(key.interestOps() | 1);
                if (buf == this.READ_BUFFER) {
                    this.allocateReadBuffer(con);
                } else {
                    buf.compact();
                }
                return false;
            }
        }
        int dataPending = (buf.getShort() & 0xFFFF) - 2;
        if (dataPending <= buf.remaining()) {
            if (dataPending > 0) {
                int pos = buf.position();
                this.parseClientPacket(pos, buf, dataPending, client);
                buf.position(pos + dataPending);
            }
            if (!buf.hasRemaining()) {
                if (buf != this.READ_BUFFER) {
                    con.setReadBuffer(null);
                    this.recycleBuffer(buf);
                } else {
                    this.READ_BUFFER.clear();
                }
                return false;
            }
            return true;
        }
        key.interestOps(key.interestOps() | 1);
        if (buf == this.READ_BUFFER) {
            buf.position(buf.position() - 2);
            this.allocateReadBuffer(con);
        } else {
            buf.position(buf.position() - 2);
            buf.compact();
        }
        return false;
    }

    private void allocateReadBuffer(MMOConnection<T> con) {
        con.setReadBuffer(this.getPooledBuffer().put(this.READ_BUFFER));
        this.READ_BUFFER.clear();
    }

    private void parseClientPacket(int pos, ByteBuffer buf, int dataSize, T client) {
        boolean ret = ((MMOClient)client).decrypt(buf, dataSize);
        if (ret && buf.hasRemaining()) {
            int limit = buf.limit();
            buf.limit(pos + dataSize);
            ReceivablePacket<T> cp = this._packetHandler.handlePacket(buf, client);
            if (cp != null) {
                cp._buf = buf;
                cp._sbuf = this.STRING_BUFFER;
                cp._client = client;
                if (cp.read()) {
                    this._executor.execute(cp);
                }
                cp._buf = null;
                cp._sbuf = null;
            }
            buf.limit(limit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeClosePacket(MMOConnection<T> con) {
        NioNetStackList<SendablePacket<T>> nioNetStackList = con.getSendQueue();
        synchronized (nioNetStackList) {
            SendablePacket<T> sp;
            if (con.getSendQueue().isEmpty()) {
                return;
            }
            while ((sp = con.getSendQueue().removeFirst()) != null) {
                this.WRITE_BUFFER.clear();
                this.putPacketIntoWriteBuffer(con.getClient(), sp);
                this.WRITE_BUFFER.flip();
                try {
                    con.write(this.WRITE_BUFFER);
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writePacket(SelectionKey key, MMOConnection<T> con) {
        if (!this.prepareWriteBuffer(con)) {
            key.interestOps(key.interestOps() & 0xFFFFFFFB);
            return;
        }
        this.DIRECT_WRITE_BUFFER.flip();
        int size = this.DIRECT_WRITE_BUFFER.remaining();
        int result = -1;
        try {
            result = con.write(this.DIRECT_WRITE_BUFFER);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (result >= 0) {
            if (result == size) {
                NioNetStackList<SendablePacket<T>> nioNetStackList = con.getSendQueue();
                synchronized (nioNetStackList) {
                    if (con.getSendQueue().isEmpty() && !con.hasPendingWriteBuffer()) {
                        key.interestOps(key.interestOps() & 0xFFFFFFFB);
                    }
                }
            } else {
                con.createWriteBuffer(this.DIRECT_WRITE_BUFFER);
            }
        } else {
            ((MMOClient)con.getClient()).onForcedDisconnection();
            this.closeConnectionImpl(key, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareWriteBuffer(MMOConnection<T> con) {
        boolean hasPending = false;
        this.DIRECT_WRITE_BUFFER.clear();
        if (con.hasPendingWriteBuffer()) {
            con.movePendingWriteBufferTo(this.DIRECT_WRITE_BUFFER);
            hasPending = true;
        }
        if (this.DIRECT_WRITE_BUFFER.remaining() > 1 && !con.hasPendingWriteBuffer()) {
            NioNetStackList<SendablePacket<T>> sendQueue = con.getSendQueue();
            T client = con.getClient();
            for (int i = 0; i < this.MAX_SEND_PER_PASS; ++i) {
                SendablePacket<T> sp;
                NioNetStackList<SendablePacket<T>> nioNetStackList = con.getSendQueue();
                synchronized (nioNetStackList) {
                    sp = sendQueue.isEmpty() ? null : sendQueue.removeFirst();
                }
                if (sp == null) break;
                hasPending = true;
                this.putPacketIntoWriteBuffer(client, sp);
                this.WRITE_BUFFER.flip();
                if (this.DIRECT_WRITE_BUFFER.remaining() < this.WRITE_BUFFER.limit()) {
                    con.createWriteBuffer(this.WRITE_BUFFER);
                    break;
                }
                this.DIRECT_WRITE_BUFFER.put(this.WRITE_BUFFER);
            }
        }
        return hasPending;
    }

    private void putPacketIntoWriteBuffer(T client, SendablePacket<T> sp) {
        this.WRITE_BUFFER.clear();
        int headerPos = this.WRITE_BUFFER.position();
        int dataPos = headerPos + 2;
        this.WRITE_BUFFER.position(dataPos);
        sp._buf = this.WRITE_BUFFER;
        sp._client = client;
        sp.write();
        sp._buf = null;
        int dataSize = this.WRITE_BUFFER.position() - dataPos;
        this.WRITE_BUFFER.position(dataPos);
        ((MMOClient)client).encrypt(this.WRITE_BUFFER, dataSize);
        dataSize = this.WRITE_BUFFER.position() - dataPos;
        this.WRITE_BUFFER.position(headerPos);
        this.WRITE_BUFFER.putShort((short)(dataSize + 2));
        this.WRITE_BUFFER.position(dataPos + dataSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void closeConnection(MMOConnection<T> con) {
        NioNetStackList<MMOConnection<T>> nioNetStackList = this._pendingClose;
        synchronized (nioNetStackList) {
            this._pendingClose.addLast(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnectionImpl(SelectionKey key, MMOConnection<T> con) {
        try {
            ((MMOClient)con.getClient()).onDisconnection();
        }
        catch (Throwable throwable) {
            try {
                con.close();
            }
            catch (IOException iOException) {
            }
            finally {
                con.releaseBuffers();
                key.attach(null);
                key.cancel();
            }
            throw throwable;
        }
        try {
            con.close();
        }
        catch (IOException iOException) {
        }
        finally {
            con.releaseBuffers();
            key.attach(null);
            key.cancel();
        }
    }

    public final void shutdown() {
        this._shutdown = true;
    }

    protected void closeSelectorThread() {
        for (SelectionKey key : this._selector.keys()) {
            try {
                key.channel().close();
            }
            catch (IOException iOException) {}
        }
        try {
            this._selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

