/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.ConfigFactory;
import org.aeonbits.owner.Factory;

public final class ConfigCache {
    private static final ConcurrentMap<Object, Config> CACHE = new ConcurrentHashMap<Object, Config>();

    private ConfigCache() {
    }

    public static <T extends Config> T getOrCreate(Class<? extends T> clazz, Map<?, ?> ... imports) {
        return ConfigCache.getOrCreate(ConfigFactory.INSTANCE, clazz, clazz, imports);
    }

    public static <T extends Config> T getOrCreate(Factory factory, Class<? extends T> clazz, Map<?, ?> ... imports) {
        return ConfigCache.getOrCreate(factory, clazz, clazz, imports);
    }

    public static <T extends Config> T getOrCreate(Object key, Class<? extends T> clazz, Map<?, ?> ... imports) {
        return ConfigCache.getOrCreate(ConfigFactory.INSTANCE, key, clazz, imports);
    }

    public static <T extends Config> T getOrCreate(Factory factory, Object key, Class<? extends T> clazz, Map<?, ?> ... imports) {
        T existing = ConfigCache.get(key);
        if (existing != null) {
            return existing;
        }
        T created = factory.create(clazz, imports);
        T raced = ConfigCache.add(key, created);
        return raced != null ? raced : created;
    }

    public static <T extends Config> T get(Object key) {
        return (T)((Config)CACHE.get(key));
    }

    public static <T extends Config> T add(Object key, T instance) {
        return (T)CACHE.putIfAbsent(key, instance);
    }

    public static Set<Object> list() {
        return Collections.unmodifiableSet(CACHE.keySet());
    }

    public static void clear() {
        CACHE.clear();
    }

    public static <T extends Config> T remove(Object key) {
        return (T)((Config)CACHE.remove(key));
    }
}

