/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver;

import com.l2jserver.commons.dao.ServerNameDAO;
import com.l2jserver.commons.network.BaseSendablePacket;
import com.l2jserver.commons.security.crypt.NewCrypt;
import com.l2jserver.commons.util.Util;
import com.l2jserver.loginserver.GameServerTable;
import com.l2jserver.loginserver.LoginServer;
import com.l2jserver.loginserver.config.Configuration;
import com.l2jserver.loginserver.network.L2JGameServerPacketHandler;
import com.l2jserver.loginserver.network.loginserverpackets.ChangePasswordResponse;
import com.l2jserver.loginserver.network.loginserverpackets.InitLS;
import com.l2jserver.loginserver.network.loginserverpackets.KickPlayer;
import com.l2jserver.loginserver.network.loginserverpackets.LoginServerFail;
import com.l2jserver.loginserver.network.loginserverpackets.RequestCharacters;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.KeyPair;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameServerThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(GameServerThread.class);
    private final Socket _connection;
    private InputStream _in;
    private OutputStream _out;
    private final RSAPublicKey _publicKey;
    private final RSAPrivateKey _privateKey;
    private NewCrypt _blowfish;
    private L2JGameServerPacketHandler.GameServerState _loginConnectionState = L2JGameServerPacketHandler.GameServerState.CONNECTED;
    private final String _connectionIp;
    private GameServerTable.GameServerInfo _gsi;
    private final Set<String> _accountsOnGameServer = ConcurrentHashMap.newKeySet();
    private String _connectionIPAddress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this._connectionIPAddress = this._connection.getInetAddress().getHostAddress();
        if (GameServerThread.isBannedGameServerIP(this._connectionIPAddress)) {
            LOG.warn("IP Address {} is on banned IP list.", (Object)this._connectionIPAddress);
            this.forceClose(1);
            return;
        }
        try {
            this.sendPacket(new InitLS(this._publicKey.getModulus().toByteArray()));
            while (true) {
                int lengthLo = this._in.read();
                int lengthHi = this._in.read();
                int length = lengthHi * 256 + lengthLo;
                if (lengthHi < 0 || this._connection.isClosed()) {
                    LOG.warn("Login terminated the connection!");
                    break;
                }
                byte[] data = new byte[length - 2];
                int receivedBytes = 0;
                int newBytes = 0;
                int left = length - 2;
                while (newBytes != -1 && receivedBytes < length - 2) {
                    newBytes = this._in.read(data, receivedBytes, left);
                    receivedBytes += newBytes;
                    left -= newBytes;
                }
                if (receivedBytes != length - 2) {
                    LOG.warn("Incomplete Packet is sent to the server, closing connection. (LS)");
                    break;
                }
                this._blowfish.decrypt(data, 0, data.length);
                boolean checksumOk = NewCrypt.verifyChecksum((byte[])data);
                if (!checksumOk) {
                    LOG.warn("Incorrect packet checksum, closing connection. (LS)");
                    return;
                }
                if (Configuration.server().isDebug()) {
                    LOG.warn("[C]" + System.lineSeparator() + Util.printData((byte[])data));
                }
                L2JGameServerPacketHandler.handlePacket(data, this);
            }
        }
        catch (IOException ex) {
            String serverName = this.getServerId() != -1 ? "[" + this.getServerId() + "] " + ServerNameDAO.getServer((int)this.getServerId()) : "(" + this._connectionIPAddress + ")";
            LOG.warn("Game Server {} lost connection!", (Object)serverName);
            this.broadcastToTelnet("Game Server " + serverName + " lost connection!");
        }
        finally {
            if (this.isAuthed()) {
                this._gsi.setDown();
                LOG.info("Server {}[{}] is now disconnected.", (Object)ServerNameDAO.getServer((int)this.getServerId()), (Object)this.getServerId());
            }
            LoginServer.getInstance().getGameServerListener().removeGameServer(this);
            LoginServer.getInstance().getGameServerListener().removeFloodProtection(this._connectionIp);
        }
    }

    public boolean hasAccountOnGameServer(String account) {
        return this._accountsOnGameServer.contains(account);
    }

    public int getPlayerCount() {
        return this._accountsOnGameServer.size();
    }

    public void attachGameServerInfo(GameServerTable.GameServerInfo gsi, int port, String[] hosts, int maxPlayers) {
        this.setGameServerInfo(gsi);
        gsi.setGameServerThread(this);
        gsi.setPort(port);
        this.setGameHosts(hosts);
        gsi.setMaxPlayers(maxPlayers);
        gsi.setAuthed(true);
    }

    public void forceClose(int reason) {
        this.sendPacket(new LoginServerFail(reason));
        try {
            this._connection.close();
        }
        catch (IOException ex) {
            LOG.debug("Failed disconnecting banned server, server already disconnected.");
        }
    }

    public static boolean isBannedGameServerIP(String ipAddress) {
        return false;
    }

    public GameServerThread(Socket con) {
        this._connection = con;
        this._connectionIp = con.getInetAddress().getHostAddress();
        try {
            this._in = this._connection.getInputStream();
            this._out = new BufferedOutputStream(this._connection.getOutputStream());
        }
        catch (IOException ex) {
            LOG.warn("There has been an error creating a connection!", (Throwable)ex);
        }
        KeyPair pair = GameServerTable.getInstance().getKeyPair();
        this._privateKey = (RSAPrivateKey)pair.getPrivate();
        this._publicKey = (RSAPublicKey)pair.getPublic();
        this._blowfish = new NewCrypt("_;v.]05-31!|+-%xT!^[$\u0000");
        this.setName(this.getClass().getSimpleName() + "-" + this.threadId() + "@" + this._connectionIp);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(BaseSendablePacket sl) {
        try {
            byte[] data = sl.getContent();
            NewCrypt.appendChecksum((byte[])data);
            if (Configuration.server().isDebug()) {
                LOG.info("[S] {}:{}{}", new Object[]{sl.getClass().getSimpleName(), System.lineSeparator(), Util.printData((byte[])data)});
            }
            this._blowfish.crypt(data, 0, data.length);
            int len = data.length + 2;
            OutputStream outputStream = this._out;
            synchronized (outputStream) {
                this._out.write(len & 0xFF);
                this._out.write(len >> 8 & 0xFF);
                this._out.write(data);
                this._out.flush();
            }
        }
        catch (IOException ex) {
            LOG.error("There has been an error while sending packet {}!", (Object)sl.getClass().getSimpleName(), (Object)ex);
        }
    }

    public void broadcastToTelnet(String msg) {
        if (LoginServer.getInstance().getStatusServer() != null) {
            LoginServer.getInstance().getStatusServer().sendMessageToTelnets(msg);
        }
    }

    public void kickPlayer(String account) {
        this.sendPacket(new KickPlayer(account));
    }

    public void requestCharacters(String account) {
        this.sendPacket(new RequestCharacters(account));
    }

    public void ChangePasswordResponse(byte successful, String characterName, String msgToSend) {
        this.sendPacket(new ChangePasswordResponse(successful, characterName, msgToSend));
    }

    public void setGameHosts(String[] hosts) {
        LOG.info("Updated game server {}[{}] IPs.", (Object)ServerNameDAO.getServer((int)this.getServerId()), (Object)this.getServerId());
        this._gsi.clearServerAddresses();
        for (int i = 0; i < hosts.length; i += 2) {
            try {
                this._gsi.addServerAddress(hosts[i], hosts[i + 1]);
                continue;
            }
            catch (Exception ex) {
                LOG.warn("There has been an error resolving host name {}!", (Object)hosts[i], (Object)ex);
            }
        }
        for (String s : this._gsi.getServerAddresses()) {
            LOG.info(s);
        }
    }

    public boolean isAuthed() {
        if (this.getGameServerInfo() == null) {
            return false;
        }
        return this.getGameServerInfo().isAuthed();
    }

    public void setGameServerInfo(GameServerTable.GameServerInfo gsi) {
        this._gsi = gsi;
    }

    public GameServerTable.GameServerInfo getGameServerInfo() {
        return this._gsi;
    }

    public String getConnectionIpAddress() {
        return this._connectionIPAddress;
    }

    public int getServerId() {
        if (this.getGameServerInfo() != null) {
            return this.getGameServerInfo().getId();
        }
        return -1;
    }

    public RSAPrivateKey getPrivateKey() {
        return this._privateKey;
    }

    public void SetBlowFish(NewCrypt blowfish) {
        this._blowfish = blowfish;
    }

    public void addAccountOnGameServer(String account) {
        this._accountsOnGameServer.add(account);
    }

    public void removeAccountOnGameServer(String account) {
        this._accountsOnGameServer.remove(account);
    }

    public L2JGameServerPacketHandler.GameServerState getLoginConnectionState() {
        return this._loginConnectionState;
    }

    public void setLoginConnectionState(L2JGameServerPacketHandler.GameServerState state) {
        this._loginConnectionState = state;
    }
}

