/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver;

import com.l2jserver.commons.util.IPv4Filter;
import com.l2jserver.loginserver.LoginController;
import com.l2jserver.loginserver.network.L2LoginClient;
import com.l2jserver.loginserver.network.serverpackets.Init;
import com.l2jserver.mmocore.AcceptFilter;
import com.l2jserver.mmocore.ClientFactory;
import com.l2jserver.mmocore.MMOConnection;
import com.l2jserver.mmocore.MMOExecutor;
import com.l2jserver.mmocore.ReceivablePacket;
import java.nio.channels.SocketChannel;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectorHelper
implements MMOExecutor<L2LoginClient>,
ClientFactory<L2LoginClient>,
AcceptFilter {
    private static final Logger LOG = LoggerFactory.getLogger(SelectorHelper.class);
    private final ThreadPoolExecutor _generalPacketsThreadPool = new ThreadPoolExecutor(4, 6, 15L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private final IPv4Filter _ipv4filter = new IPv4Filter();

    public void execute(ReceivablePacket<L2LoginClient> packet) {
        this._generalPacketsThreadPool.execute((Runnable)packet);
    }

    public L2LoginClient create(MMOConnection<L2LoginClient> con) {
        L2LoginClient client = new L2LoginClient(con);
        client.sendPacket(new Init(client));
        return client;
    }

    public boolean accept(SocketChannel sc) {
        try {
            return this._ipv4filter.accept(sc) && !LoginController.getInstance().isBannedAddress(sc.socket().getInetAddress());
        }
        catch (Exception ex) {
            LOG.error("Invalid address {}!", (Object)sc.socket().getInetAddress(), (Object)ex);
            return false;
        }
    }
}

