/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver.model;

import java.util.Objects;

public final class AccountInfo {
    private final String _login;
    private final String _passHash;
    private final int _accessLevel;
    private final int _lastServer;

    public AccountInfo(String login, String passHash, int accessLevel, int lastServer) {
        Objects.requireNonNull(login, "login parameter is null");
        Objects.requireNonNull(passHash, "passHash parameter is null");
        if (login.isEmpty()) {
            throw new IllegalArgumentException("login string is empty");
        }
        if (passHash.isEmpty()) {
            throw new IllegalArgumentException("passHash string is empty");
        }
        this._login = login.toLowerCase();
        this._passHash = passHash;
        this._accessLevel = accessLevel;
        this._lastServer = lastServer;
    }

    public boolean checkPassHash(String passHash) {
        return this._passHash.equals(passHash);
    }

    public String getLogin() {
        return this._login;
    }

    public int getAccessLevel() {
        return this._accessLevel;
    }

    public int getLastServer() {
        return this._lastServer;
    }
}

