/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver.network;

import com.l2jserver.commons.network.BaseRecievePacket;
import com.l2jserver.loginserver.GameServerThread;
import com.l2jserver.loginserver.config.Configuration;
import com.l2jserver.loginserver.network.gameserverpackets.BlowFishKey;
import com.l2jserver.loginserver.network.gameserverpackets.ChangeAccessLevel;
import com.l2jserver.loginserver.network.gameserverpackets.ChangePassword;
import com.l2jserver.loginserver.network.gameserverpackets.GameServerAuth;
import com.l2jserver.loginserver.network.gameserverpackets.PlayerAuthRequest;
import com.l2jserver.loginserver.network.gameserverpackets.PlayerInGame;
import com.l2jserver.loginserver.network.gameserverpackets.PlayerLogout;
import com.l2jserver.loginserver.network.gameserverpackets.PlayerTracert;
import com.l2jserver.loginserver.network.gameserverpackets.ReplyCharacters;
import com.l2jserver.loginserver.network.gameserverpackets.RequestSendMail;
import com.l2jserver.loginserver.network.gameserverpackets.RequestTempBan;
import com.l2jserver.loginserver.network.gameserverpackets.ServerStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class L2JGameServerPacketHandler {
    private static final Logger LOG = LoggerFactory.getLogger(L2JGameServerPacketHandler.class);

    public static BaseRecievePacket handlePacket(byte[] data, GameServerThread server) {
        BaseRecievePacket msg = null;
        int opcode = data[0] & 0xFF;
        GameServerState state = server.getLoginConnectionState();
        block0 : switch (state.ordinal()) {
            case 0: {
                if (opcode == 0) {
                    msg = new BlowFishKey(data, server);
                    break;
                }
                LOG.warn("Unknown Opcode {} in state {} from game server, closing connection!", (Object)Integer.toHexString(opcode).toUpperCase(), (Object)state);
                server.forceClose(6);
                break;
            }
            case 1: {
                if (opcode == 1) {
                    msg = new GameServerAuth(data, server);
                    break;
                }
                LOG.warn("Unknown Opcode {} in state {} from game server, closing connection!", (Object)Integer.toHexString(opcode).toUpperCase(), (Object)state);
                server.forceClose(6);
                break;
            }
            case 2: {
                switch (opcode) {
                    case 2: {
                        msg = new PlayerInGame(data, server);
                        break block0;
                    }
                    case 3: {
                        msg = new PlayerLogout(data, server);
                        break block0;
                    }
                    case 4: {
                        msg = new ChangeAccessLevel(data, server);
                        break block0;
                    }
                    case 5: {
                        msg = new PlayerAuthRequest(data, server);
                        break block0;
                    }
                    case 6: {
                        msg = new ServerStatus(data, server);
                        break block0;
                    }
                    case 7: {
                        msg = new PlayerTracert(data);
                        break block0;
                    }
                    case 8: {
                        msg = new ReplyCharacters(data, server);
                        break block0;
                    }
                    case 9: {
                        if (!Configuration.email().isEnabled()) break block0;
                        msg = new RequestSendMail(data);
                        break block0;
                    }
                    case 10: {
                        msg = new RequestTempBan(data);
                        break block0;
                    }
                    case 11: {
                        new ChangePassword(data);
                        break block0;
                    }
                }
                LOG.warn("Unknown Opcode {} in state {} from GameServer, closing connection!", (Object)Integer.toHexString(opcode).toUpperCase(), (Object)state);
                server.forceClose(6);
            }
        }
        return msg;
    }

    public static enum GameServerState {
        CONNECTED,
        BF_CONNECTED,
        AUTHED;

    }
}

