/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver.network.gameserverpackets;

import com.l2jserver.commons.network.BaseRecievePacket;
import com.l2jserver.commons.security.crypt.NewCrypt;
import com.l2jserver.loginserver.GameServerThread;
import com.l2jserver.loginserver.config.Configuration;
import com.l2jserver.loginserver.network.L2JGameServerPacketHandler;
import javax.crypto.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlowFishKey
extends BaseRecievePacket {
    private static final Logger LOG = LoggerFactory.getLogger(BlowFishKey.class);

    public BlowFishKey(byte[] decrypt, GameServerThread server) {
        super(decrypt);
        int size = this.readD();
        byte[] tempKey = this.readB(size);
        try {
            int i;
            Cipher rsaCipher = Cipher.getInstance("RSA/ECB/nopadding");
            rsaCipher.init(2, server.getPrivateKey());
            byte[] tempDecryptKey = rsaCipher.doFinal(tempKey);
            int len = tempDecryptKey.length;
            for (i = 0; i < len && tempDecryptKey[i] == 0; ++i) {
            }
            byte[] key = new byte[len - i];
            System.arraycopy(tempDecryptKey, i, key, 0, len - i);
            server.SetBlowFish(new NewCrypt(key));
            if (Configuration.server().isDebug()) {
                LOG.info("New BlowFish key received, Blowfish Engine initialized:");
            }
            server.setLoginConnectionState(L2JGameServerPacketHandler.GameServerState.BF_CONNECTED);
        }
        catch (Exception ex) {
            LOG.error("There has been an error while decrypting blowfish key (RSA)!", (Throwable)ex);
        }
    }
}

