/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver;

import com.l2jserver.commons.dao.ServerNameDAO;
import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.commons.util.Rnd;
import com.l2jserver.loginserver.GameServerThread;
import com.l2jserver.loginserver.util.IPSubnet;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.spec.RSAKeyGenParameterSpec;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GameServerTable {
    private static final Logger LOG = LoggerFactory.getLogger(GameServerTable.class);
    private static final Map<Integer, GameServerInfo> GAME_SERVER_TABLE = new HashMap<Integer, GameServerInfo>();
    private static final int KEYS_SIZE = 10;
    private KeyPair[] _keyPairs;

    public GameServerTable() {
        this.loadRegisteredGameServers();
        LOG.info("{}: Loaded {} registered Game Servers.", (Object)this.getClass().getSimpleName(), (Object)GAME_SERVER_TABLE.size());
        this.initRSAKeys();
        LOG.info("{}: Cached {} RSA keys for Game Server communication.", (Object)this.getClass().getSimpleName(), (Object)this._keyPairs.length);
    }

    private void initRSAKeys() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(new RSAKeyGenParameterSpec(512, RSAKeyGenParameterSpec.F4));
            this._keyPairs = new KeyPair[10];
            for (int i = 0; i < 10; ++i) {
                this._keyPairs[i] = keyGen.genKeyPair();
            }
        }
        catch (Exception e) {
            LOG.error("{}: Error loading RSA keys for Game Server communication!", (Object)this.getClass().getSimpleName(), (Object)e);
        }
    }

    private void loadRegisteredGameServers() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement ps = con.createStatement();
             ResultSet rs = ps.executeQuery("SELECT * FROM gameservers");){
            while (rs.next()) {
                int id = rs.getInt("server_id");
                GAME_SERVER_TABLE.put(id, new GameServerInfo(id, this.stringToHex(rs.getString("hexid"))));
            }
        }
        catch (Exception e) {
            LOG.error("{}: Error loading registered game servers!", (Object)this.getClass().getSimpleName(), (Object)e);
        }
    }

    public Map<Integer, GameServerInfo> getRegisteredGameServers() {
        return GAME_SERVER_TABLE;
    }

    public GameServerInfo getRegisteredGameServerById(int id) {
        return GAME_SERVER_TABLE.get(id);
    }

    public boolean hasRegisteredGameServerOnId(int id) {
        return GAME_SERVER_TABLE.containsKey(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerWithFirstAvailableId(GameServerInfo gsi) {
        Map<Integer, GameServerInfo> map = GAME_SERVER_TABLE;
        synchronized (map) {
            for (Integer serverId : ServerNameDAO.getServers().keySet()) {
                if (GAME_SERVER_TABLE.containsKey(serverId)) continue;
                GAME_SERVER_TABLE.put(serverId, gsi);
                gsi.setId(serverId);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean register(int id, GameServerInfo gsi) {
        Map<Integer, GameServerInfo> map = GAME_SERVER_TABLE;
        synchronized (map) {
            if (!GAME_SERVER_TABLE.containsKey(id)) {
                GAME_SERVER_TABLE.put(id, gsi);
                return true;
            }
        }
        return false;
    }

    public void registerServerOnDB(GameServerInfo gsi) {
        this.registerServerOnDB(gsi.getHexId(), gsi.getId(), gsi.getExternalHost());
    }

    public void registerServerOnDB(byte[] hexId, int id, String externalHost) {
        this.register(id, new GameServerInfo(id, hexId));
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("INSERT INTO gameservers (hexid,server_id,host) values (?,?,?)");){
            ps.setString(1, this.hexToString(hexId));
            ps.setInt(2, id);
            ps.setString(3, externalHost);
            ps.executeUpdate();
        }
        catch (Exception e) {
            LOG.error("{}: Error while saving game server!", (Object)this.getClass().getSimpleName(), (Object)e);
        }
    }

    public KeyPair getKeyPair() {
        return this._keyPairs[Rnd.nextInt((int)10)];
    }

    private byte[] stringToHex(String string) {
        return new BigInteger(string, 16).toByteArray();
    }

    private String hexToString(byte[] hex) {
        if (hex == null) {
            return "null";
        }
        return new BigInteger(hex).toString(16);
    }

    public static GameServerTable getInstance() {
        return SingletonHolder._instance;
    }

    public static class GameServerInfo {
        private int _id;
        private final byte[] _hexId;
        private boolean _isAuthed;
        private GameServerThread _gst;
        private int _status;
        private final ArrayList<GameServerAddress> _addresses = new ArrayList(5);
        private int _port;
        private final boolean _isPvp = true;
        private int _serverType;
        private int _ageLimit;
        private boolean _isShowingBrackets;
        private int _maxPlayers;

        public GameServerInfo(int id, byte[] hexId, GameServerThread gst) {
            this._id = id;
            this._hexId = hexId;
            this._gst = gst;
            this._status = 4;
        }

        public GameServerInfo(int id, byte[] hexId) {
            this(id, hexId, null);
        }

        public void setId(int id) {
            this._id = id;
        }

        public int getId() {
            return this._id;
        }

        public byte[] getHexId() {
            return this._hexId;
        }

        public String getName() {
            return ServerNameDAO.getServer((int)this._id);
        }

        public void setAuthed(boolean isAuthed) {
            this._isAuthed = isAuthed;
        }

        public boolean isAuthed() {
            return this._isAuthed;
        }

        public void setGameServerThread(GameServerThread gst) {
            this._gst = gst;
        }

        public GameServerThread getGameServerThread() {
            return this._gst;
        }

        public void setStatus(int status) {
            this._status = status;
        }

        public int getStatus() {
            return this._status;
        }

        public String getStatusName() {
            return switch (this._status) {
                case 0 -> "Auto";
                case 1 -> "Good";
                case 2 -> "Normal";
                case 3 -> "Full";
                case 4 -> "Down";
                case 5 -> "GM Only";
                default -> "Unknown";
            };
        }

        public int getCurrentPlayerCount() {
            if (this._gst == null) {
                return 0;
            }
            return this._gst.getPlayerCount();
        }

        public String getExternalHost() {
            try {
                return this.getServerAddress(InetAddress.getByName("0.0.0.0"));
            }
            catch (Exception exception) {
                return null;
            }
        }

        public int getPort() {
            return this._port;
        }

        public void setPort(int port) {
            this._port = port;
        }

        public void setMaxPlayers(int maxPlayers) {
            this._maxPlayers = maxPlayers;
        }

        public int getMaxPlayers() {
            return this._maxPlayers;
        }

        public boolean isPvp() {
            return true;
        }

        public void setAgeLimit(int val) {
            this._ageLimit = val;
        }

        public int getAgeLimit() {
            return this._ageLimit;
        }

        public void setServerType(int val) {
            this._serverType = val;
        }

        public int getServerType() {
            return this._serverType;
        }

        public void setShowingBrackets(boolean val) {
            this._isShowingBrackets = val;
        }

        public boolean isShowingBrackets() {
            return this._isShowingBrackets;
        }

        public void setDown() {
            this.setAuthed(false);
            this.setPort(0);
            this.setGameServerThread(null);
            this.setStatus(4);
        }

        public void addServerAddress(String subnet, String addr) throws UnknownHostException {
            this._addresses.add(new GameServerAddress(subnet, addr));
        }

        public String getServerAddress(InetAddress addr) {
            for (GameServerAddress a : this._addresses) {
                if (!a.equals(addr)) continue;
                return a.getServerAddress();
            }
            return null;
        }

        public String[] getServerAddresses() {
            String[] result = new String[this._addresses.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this._addresses.get(i).toString();
            }
            return result;
        }

        public void clearServerAddresses() {
            this._addresses.clear();
        }

        private static class GameServerAddress
        extends IPSubnet {
            private final String _serverAddress;

            public GameServerAddress(String subnet, String address) throws UnknownHostException {
                super(subnet);
                this._serverAddress = address;
            }

            public String getServerAddress() {
                return this._serverAddress;
            }

            @Override
            public String toString() {
                return this._serverAddress + super.toString();
            }
        }
    }

    private static class SingletonHolder {
        protected static final GameServerTable _instance = new GameServerTable();

        private SingletonHolder() {
        }
    }
}

