/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.commons.util.Rnd;
import com.l2jserver.loginserver.GameServerTable;
import com.l2jserver.loginserver.GameServerThread;
import com.l2jserver.loginserver.SessionKey;
import com.l2jserver.loginserver.config.Configuration;
import com.l2jserver.loginserver.model.AccountInfo;
import com.l2jserver.loginserver.network.L2LoginClient;
import com.l2jserver.loginserver.network.serverpackets.LoginFail;
import com.l2jserver.loginserver.security.ScrambledKeyPair;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.RSAKeyGenParameterSpec;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginController {
    private static final Logger LOG = LoggerFactory.getLogger(LoginController.class);
    public static final int LOGIN_TIMEOUT = 60000;
    protected final Map<String, L2LoginClient> _loginServerClients = new ConcurrentHashMap<String, L2LoginClient>();
    private final Map<InetAddress, Integer> _failedLoginAttempts = new ConcurrentHashMap<InetAddress, Integer>();
    private final Map<InetAddress, Long> _bannedIps = new ConcurrentHashMap<InetAddress, Long>();
    protected final ScrambledKeyPair[] _keyPairs;
    protected byte[][] _blowfishKeys;
    private static final int BLOWFISH_KEYS = 20;
    private static final String USER_INFO_SELECT = "SELECT login, password, IF(? > value OR value IS NULL, accessLevel, -1) AS accessLevel, lastServer FROM accounts LEFT JOIN (account_data) ON (account_data.account_name=accounts.login AND account_data.var=\"ban_temp\") WHERE login=?";
    private static final String AUTO_CREATE_ACCOUNTS_INSERT = "INSERT INTO accounts (login, password, lastactive, accessLevel, lastIP) values (?, ?, ?, ?, ?)";
    private static final String ACCOUNT_INFO_UPDATE = "UPDATE accounts SET lastactive = ?, lastIP = ? WHERE login = ?";
    private static final String ACCOUNT_LAST_SERVER_UPDATE = "UPDATE accounts SET lastServer = ? WHERE login = ?";
    private static final String ACCOUNT_ACCESS_LEVEL_UPDATE = "UPDATE accounts SET accessLevel = ? WHERE login = ?";
    private static final String ACCOUNT_IPS_UPDATE = "UPDATE accounts SET pcIp = ?, hop1 = ?, hop2 = ?, hop3 = ?, hop4 = ? WHERE login = ?";
    private static final String ACCOUNT_IPAUTH_SELECT = "SELECT * FROM accounts_ipauth WHERE login = ?";

    private LoginController() {
        LOG.info("Loading Login Controller...");
        this._keyPairs = new ScrambledKeyPair[10];
        try {
            KeyPairGenerator keygen = KeyPairGenerator.getInstance("RSA");
            RSAKeyGenParameterSpec spec = new RSAKeyGenParameterSpec(1024, RSAKeyGenParameterSpec.F4);
            keygen.initialize(spec);
            for (int i = 0; i < 10; ++i) {
                this._keyPairs[i] = new ScrambledKeyPair(keygen.generateKeyPair());
            }
            this.testCipher((RSAPrivateKey)this._keyPairs[0].getPair().getPrivate());
            LOG.info("Cached 10 KeyPairs for RSA communication.");
        }
        catch (Exception ex) {
            LOG.error("There has been an error loading the key pairs!", (Throwable)ex);
        }
        this.generateBlowFishKeys();
        PurgeThread purge = new PurgeThread();
        purge.setDaemon(true);
        purge.start();
    }

    private void testCipher(RSAPrivateKey key) throws Exception {
        Cipher rsaCipher = Cipher.getInstance("RSA/ECB/nopadding");
        rsaCipher.init(2, key);
    }

    private void generateBlowFishKeys() {
        this._blowfishKeys = new byte[20][16];
        for (int i = 0; i < 20; ++i) {
            for (int j = 0; j < this._blowfishKeys[i].length; ++j) {
                this._blowfishKeys[i][j] = (byte)(Rnd.nextInt((int)255) + 1);
            }
        }
        LOG.info("Stored {} keys for Blowfish communication.", (Object)this._blowfishKeys.length);
    }

    public byte[] getBlowfishKey() {
        return this._blowfishKeys[(int)(Math.random() * 20.0)];
    }

    public SessionKey assignSessionKeyToClient(String account, L2LoginClient client) {
        SessionKey key = new SessionKey(Rnd.nextInt(), Rnd.nextInt(), Rnd.nextInt(), Rnd.nextInt());
        this._loginServerClients.put(account, client);
        return key;
    }

    public void removeAuthedLoginClient(String account) {
        if (account == null) {
            return;
        }
        this._loginServerClients.remove(account);
    }

    public L2LoginClient getAuthedClient(String account) {
        return this._loginServerClients.get(account);
    }

    public AccountInfo retrieveAccountInfo(InetAddress clientAddr, String login, String password) {
        return this.retrieveAccountInfo(clientAddr, login, password, true);
    }

    private void recordFailedLoginAttempt(InetAddress addr) {
        int failedLoginAttempts = this._failedLoginAttempts.getOrDefault(addr, 0) + 1;
        this._failedLoginAttempts.put(addr, failedLoginAttempts);
        if (failedLoginAttempts >= Configuration.server().getLoginTryBeforeBan()) {
            this.addBanForAddress(addr, (long)(Configuration.server().getLoginBlockAfterBan() * 1000));
            this.clearFailedLoginAttempts(addr);
            LOG.warn("Added banned address {}, too many login attempts!", (Object)addr.getHostAddress());
        }
    }

    private void clearFailedLoginAttempts(InetAddress addr) {
        this._failedLoginAttempts.remove(addr);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AccountInfo retrieveAccountInfo(InetAddress addr, String login, String password, boolean autoCreateIfEnabled) {
        try {
            PreparedStatement ps;
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] raw = password.getBytes(StandardCharsets.UTF_8);
            String hashBase64 = Base64.getEncoder().encodeToString(md.digest(raw));
            try (Connection con = ConnectionFactory.getInstance().getConnection();){
                ps = con.prepareStatement(USER_INFO_SELECT);
                try {
                    ps.setString(1, Long.toString(System.currentTimeMillis()));
                    ps.setString(2, login);
                    try (ResultSet rs = ps.executeQuery();){
                        if (rs.next()) {
                            AccountInfo info;
                            if (Configuration.server().isDebug()) {
                                LOG.info("Account {} exists.", (Object)login);
                            }
                            if (!(info = new AccountInfo(rs.getString("login"), rs.getString("password"), rs.getInt("accessLevel"), rs.getInt("lastServer"))).checkPassHash(hashBase64)) {
                                this.recordFailedLoginAttempt(addr);
                                AccountInfo accountInfo = null;
                                return accountInfo;
                            }
                            this.clearFailedLoginAttempts(addr);
                            AccountInfo accountInfo = info;
                            return accountInfo;
                        }
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            if (!autoCreateIfEnabled || !Configuration.server().autoCreateAccounts()) {
                this.recordFailedLoginAttempt(addr);
                return null;
            }
            try {
                con = ConnectionFactory.getInstance().getConnection();
                try {
                    ps = con.prepareStatement(AUTO_CREATE_ACCOUNTS_INSERT);
                    try {
                        ps.setString(1, login);
                        ps.setString(2, hashBase64);
                        ps.setLong(3, System.currentTimeMillis());
                        ps.setInt(4, Configuration.server().autoCreateAccountsAccessLevel());
                        ps.setString(5, addr.getHostAddress());
                        ps.execute();
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
                finally {
                    if (con != null) {
                        con.close();
                    }
                }
            }
            catch (Exception ex) {
                LOG.warn("There has been an error auto-creating the account {}!", (Object)login, (Object)ex);
                return null;
            }
            LOG.info("Auto-created account {}.", (Object)login);
            return this.retrieveAccountInfo(addr, login, password, false);
        }
        catch (Exception ex) {
            LOG.warn("There has been an error getting account info for {}!", (Object)login, (Object)ex);
            return null;
        }
    }

    public AuthLoginResult tryCheckinAccount(L2LoginClient client, InetAddress address, AccountInfo info) {
        if (info.getAccessLevel() < 0) {
            if (info.getAccessLevel() == Configuration.server().autoCreateAccountsAccessLevel()) {
                return AuthLoginResult.ACCOUNT_INACTIVE;
            }
            return AuthLoginResult.ACCOUNT_BANNED;
        }
        AuthLoginResult ret = AuthLoginResult.INVALID_PASSWORD;
        if (this.canCheckIn(client, address, info)) {
            ret = AuthLoginResult.ALREADY_ON_GS;
            if (!this.isAccountInAnyGameServer(info.getLogin())) {
                ret = AuthLoginResult.ALREADY_ON_LS;
                if (this._loginServerClients.putIfAbsent(info.getLogin(), client) == null) {
                    ret = AuthLoginResult.AUTH_SUCCESS;
                }
            }
        }
        return ret;
    }

    public void addBanForAddress(String address, long expiration) throws Exception {
        this._bannedIps.putIfAbsent(InetAddress.getByName(address), expiration);
    }

    public void addBanForAddress(InetAddress address, long duration) {
        this._bannedIps.putIfAbsent(address, System.currentTimeMillis() + duration);
    }

    public boolean isBannedAddress(InetAddress address) throws Exception {
        String[] parts = address.getHostAddress().split("\\.");
        Long bi = this._bannedIps.get(address);
        if (bi == null) {
            bi = this._bannedIps.get(InetAddress.getByName(parts[0] + "." + parts[1] + "." + parts[2] + ".0"));
        }
        if (bi == null) {
            bi = this._bannedIps.get(InetAddress.getByName(parts[0] + "." + parts[1] + ".0.0"));
        }
        if (bi == null) {
            bi = this._bannedIps.get(InetAddress.getByName(parts[0] + ".0.0.0"));
        }
        if (bi != null) {
            if (bi > 0L && bi < System.currentTimeMillis()) {
                this._bannedIps.remove(address);
                LOG.info("Removed expired IP address ban {}.", (Object)address.getHostAddress());
                return false;
            }
            return true;
        }
        return false;
    }

    public Map<InetAddress, Long> getBannedIps() {
        return this._bannedIps;
    }

    public boolean removeBanForAddress(InetAddress address) {
        return this._bannedIps.remove(address) != null;
    }

    public boolean removeBanForAddress(String address) {
        try {
            return this.removeBanForAddress(InetAddress.getByName(address));
        }
        catch (Exception e) {
            return false;
        }
    }

    public SessionKey getKeyForAccount(String account) {
        L2LoginClient client = this._loginServerClients.get(account);
        if (client != null) {
            return client.getSessionKey();
        }
        return null;
    }

    public boolean isAccountInAnyGameServer(String account) {
        Collection<GameServerTable.GameServerInfo> serverList = GameServerTable.getInstance().getRegisteredGameServers().values();
        for (GameServerTable.GameServerInfo gsi : serverList) {
            GameServerThread gst = gsi.getGameServerThread();
            if (gst == null || !gst.hasAccountOnGameServer(account)) continue;
            return true;
        }
        return false;
    }

    public GameServerTable.GameServerInfo getAccountOnGameServer(String account) {
        Collection<GameServerTable.GameServerInfo> serverList = GameServerTable.getInstance().getRegisteredGameServers().values();
        for (GameServerTable.GameServerInfo gsi : serverList) {
            GameServerThread gst = gsi.getGameServerThread();
            if (gst == null || !gst.hasAccountOnGameServer(account)) continue;
            return gsi;
        }
        return null;
    }

    public void getCharactersOnAccount(String account) {
        Collection<GameServerTable.GameServerInfo> serverList = GameServerTable.getInstance().getRegisteredGameServers().values();
        for (GameServerTable.GameServerInfo gsi : serverList) {
            if (!gsi.isAuthed()) continue;
            gsi.getGameServerThread().requestCharacters(account);
        }
    }

    public boolean isLoginPossible(L2LoginClient client, int serverId) {
        GameServerTable.GameServerInfo gsi = GameServerTable.getInstance().getRegisteredGameServerById(serverId);
        int access = client.getAccessLevel();
        if (gsi != null && gsi.isAuthed()) {
            boolean loginOk;
            boolean bl = loginOk = gsi.getCurrentPlayerCount() < gsi.getMaxPlayers() && gsi.getStatus() != 5 || access > 0;
            if (loginOk && client.getLastServer() != serverId) {
                try (Connection con = ConnectionFactory.getInstance().getConnection();
                     PreparedStatement ps = con.prepareStatement(ACCOUNT_LAST_SERVER_UPDATE);){
                    ps.setInt(1, serverId);
                    ps.setString(2, client.getAccount());
                    ps.executeUpdate();
                }
                catch (Exception ex) {
                    LOG.warn("There has been an error setting last server for account {}!", (Object)client.getAccount(), (Object)ex);
                }
            }
            return loginOk;
        }
        return false;
    }

    public void setAccountAccessLevel(String account, int banLevel) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(ACCOUNT_ACCESS_LEVEL_UPDATE);){
            ps.setInt(1, banLevel);
            ps.setString(2, account);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            LOG.warn("There has been an error setting account level for account {}!", (Object)account, (Object)ex);
        }
    }

    public void setAccountLastTracert(String account, String pcIp, String hop1, String hop2, String hop3, String hop4) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(ACCOUNT_IPS_UPDATE);){
            ps.setString(1, pcIp);
            ps.setString(2, hop1);
            ps.setString(3, hop2);
            ps.setString(4, hop3);
            ps.setString(5, hop4);
            ps.setString(6, account);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            LOG.warn("There has been an error setting last tracert for account {}!", (Object)account, (Object)ex);
        }
    }

    public void setCharactersOnServer(String account, int charsNum, long[] timeToDel, int serverId) {
        L2LoginClient client = this._loginServerClients.get(account);
        if (client == null) {
            return;
        }
        if (charsNum > 0) {
            client.setCharsOnServ(serverId, charsNum);
        }
        if (timeToDel.length > 0) {
            client.serCharsWaitingDelOnServ(serverId, timeToDel);
        }
    }

    public ScrambledKeyPair getScrambledRSAKeyPair() {
        return this._keyPairs[Rnd.nextInt((int)10)];
    }

    public boolean canCheckIn(L2LoginClient client, InetAddress address, AccountInfo info) {
        try {
            PreparedStatement ps;
            ArrayList<InetAddress> ipWhiteList = new ArrayList<InetAddress>();
            ArrayList<InetAddress> ipBlackList = new ArrayList<InetAddress>();
            try (Connection con = ConnectionFactory.getInstance().getConnection();){
                ps = con.prepareStatement(ACCOUNT_IPAUTH_SELECT);
                try {
                    ps.setString(1, info.getLogin());
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            String ip = rs.getString("ip");
                            if (!this.isValidIPAddress(ip)) continue;
                            String type = rs.getString("type");
                            if (type.equals("allow")) {
                                ipWhiteList.add(InetAddress.getByName(ip));
                                continue;
                            }
                            if (!type.equals("deny")) continue;
                            ipBlackList.add(InetAddress.getByName(ip));
                        }
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            if (!ipWhiteList.isEmpty() || !ipBlackList.isEmpty()) {
                if (!ipWhiteList.isEmpty() && !ipWhiteList.contains(address)) {
                    LOG.warn("Account checkin attempt from address {} not present on whitelist for account {}!", (Object)address.getHostAddress(), (Object)info.getLogin());
                    return false;
                }
                if (!ipBlackList.isEmpty() && ipBlackList.contains(address)) {
                    LOG.warn("Account checkin attempt from address {} on blacklist for account {}!", (Object)address.getHostAddress(), (Object)info.getLogin());
                    return false;
                }
            }
            client.setAccessLevel(info.getAccessLevel());
            client.setLastServer(info.getLastServer());
            con = ConnectionFactory.getInstance().getConnection();
            try {
                ps = con.prepareStatement(ACCOUNT_INFO_UPDATE);
                try {
                    ps.setLong(1, System.currentTimeMillis());
                    ps.setString(2, address.getHostAddress());
                    ps.setString(3, info.getLogin());
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            finally {
                if (con != null) {
                    con.close();
                }
            }
            return true;
        }
        catch (Exception ex) {
            LOG.warn("There has been an error logging in!", (Throwable)ex);
            return false;
        }
    }

    public boolean isValidIPAddress(String ipAddress) {
        String[] parts = ipAddress.split("\\.");
        if (parts.length != 4) {
            return false;
        }
        for (String s : parts) {
            int i = Integer.parseInt(s);
            if (i >= 0 && i <= 255) continue;
            return false;
        }
        return true;
    }

    public static LoginController getInstance() {
        return SingletonHolder.INSTANCE;
    }

    class PurgeThread
    extends Thread {
        public PurgeThread() {
            this.setName("PurgeThread");
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                for (L2LoginClient client : LoginController.this._loginServerClients.values()) {
                    if (client == null || client.getConnectionStartTime() + 60000L >= System.currentTimeMillis()) continue;
                    client.close(LoginFail.LoginFailReason.REASON_ACCESS_FAILED);
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    public static enum AuthLoginResult {
        INVALID_PASSWORD,
        ACCOUNT_INACTIVE,
        ACCOUNT_BANNED,
        ALREADY_ON_LS,
        ALREADY_ON_GS,
        AUTH_SUCCESS;

    }

    private static class SingletonHolder {
        protected static final LoginController INSTANCE = new LoginController();

        private SingletonHolder() {
        }
    }
}

