/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver;

import com.l2jserver.commons.UPnPService;
import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.loginserver.GameServerListener;
import com.l2jserver.loginserver.GameServerTable;
import com.l2jserver.loginserver.LoginController;
import com.l2jserver.loginserver.SelectorHelper;
import com.l2jserver.loginserver.config.Configuration;
import com.l2jserver.loginserver.mail.MailSystem;
import com.l2jserver.loginserver.network.L2LoginClient;
import com.l2jserver.loginserver.network.L2LoginPacketHandler;
import com.l2jserver.loginserver.status.Status;
import com.l2jserver.mmocore.AcceptFilter;
import com.l2jserver.mmocore.ClientFactory;
import com.l2jserver.mmocore.MMOExecutor;
import com.l2jserver.mmocore.PacketHandler;
import com.l2jserver.mmocore.SelectorConfig;
import com.l2jserver.mmocore.SelectorThread;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoginServer {
    private static final Logger LOG = LoggerFactory.getLogger(LoginServer.class);
    private static final String BANNED_IPS = "/config/banned_ip.cfg";
    private static LoginServer _instance;
    private GameServerListener _gameServerListener;
    private SelectorThread<L2LoginClient> _selectorThread;
    private Status _statusServer;

    public static void main(String[] args) {
        new LoginServer();
    }

    public static LoginServer getInstance() {
        return _instance;
    }

    private LoginServer() {
        _instance = this;
        ConnectionFactory.builder().withUrl(Configuration.database().getURL()).withUser(Configuration.database().getUser()).withPassword(Configuration.database().getPassword()).withMaxIdleTime(Configuration.database().getMaxIdleTime().intValue()).withMaxPoolSize(Configuration.database().getMaxConnections().intValue()).build();
        LoginController.getInstance();
        GameServerTable.getInstance();
        this.loadBanFile();
        if (Configuration.email().isEnabled()) {
            MailSystem.getInstance();
        }
        SelectorConfig sc = new SelectorConfig();
        sc.MAX_READ_PER_PASS = Configuration.mmo().getMaxReadPerPass();
        sc.MAX_SEND_PER_PASS = Configuration.mmo().getMaxSendPerPass();
        sc.SLEEP_TIME = Configuration.mmo().getSleepTime();
        sc.HELPER_BUFFER_COUNT = Configuration.mmo().getHelperBufferCount();
        L2LoginPacketHandler loginPacketHandler = new L2LoginPacketHandler();
        SelectorHelper selectorHelper = new SelectorHelper();
        try {
            this._selectorThread = new SelectorThread(sc, (MMOExecutor)selectorHelper, (PacketHandler)loginPacketHandler, (ClientFactory)selectorHelper, (AcceptFilter)selectorHelper);
        }
        catch (Exception ex) {
            LOG.error("Failed to open Selector!", (Throwable)ex);
            System.exit(1);
        }
        try {
            this._gameServerListener = new GameServerListener();
            this._gameServerListener.start();
            LOG.info("Listening for game servers on {}:{}.", (Object)Configuration.server().getGameServerHost(), (Object)Configuration.server().getGameServerPort());
        }
        catch (Exception ex) {
            LOG.error("Failed to start the Game Server Listener!", (Throwable)ex);
            System.exit(1);
        }
        if (Configuration.telnet().isEnabled()) {
            try {
                this._statusServer = new Status();
                this._statusServer.start();
            }
            catch (Exception ex) {
                LOG.warn("Failed to start the Telnet Server!", (Throwable)ex);
            }
        } else {
            LOG.info("Telnet server is currently disabled.");
        }
        InetAddress bindAddress = null;
        if (!Configuration.server().getHost().equals("*")) {
            try {
                bindAddress = InetAddress.getByName(Configuration.server().getGameServerHost());
            }
            catch (Exception ex) {
                LOG.warn("The Login Server bind address is invalid, using all available IPs!", (Throwable)ex);
            }
        }
        try {
            this._selectorThread.openServerSocket(bindAddress, Configuration.server().getPort());
            this._selectorThread.start();
            LOG.info("Login Server is now listening on {}:{}.", (Object)Configuration.server().getHost(), (Object)Configuration.server().getPort());
        }
        catch (Exception ex) {
            LOG.error("Failed to open server socket!", (Throwable)ex);
            System.exit(1);
        }
        if (Configuration.server().isUPnPEnabled()) {
            UPnPService.getInstance().load(Configuration.server().getPort(), "L2J Login Server");
        }
    }

    public Status getStatusServer() {
        return this._statusServer;
    }

    public GameServerListener getGameServerListener() {
        return this._gameServerListener;
    }

    private void loadBanFile() {
        try (InputStream fis = this.getClass().getResourceAsStream(BANNED_IPS);
             InputStreamReader is = new InputStreamReader(fis);
             LineNumberReader lnr = new LineNumberReader(is);){
            lnr.lines().map(String::trim).filter(l -> !l.isEmpty() && l.charAt(0) != '#').forEach(line -> {
                String[] parts = line.split("#", 2);
                line = parts[0];
                parts = line.split("\\s+");
                String address = parts[0];
                long duration = 0L;
                if (parts.length > 1) {
                    try {
                        duration = Long.parseLong(parts[1]);
                    }
                    catch (Exception ex) {
                        LOG.warn("Incorrect ban duration {} on line {} on file {}!", new Object[]{parts[1], lnr.getLineNumber(), BANNED_IPS, ex});
                        return;
                    }
                }
                try {
                    LoginController.getInstance().addBanForAddress(address, duration);
                }
                catch (Exception ex) {
                    LOG.warn("Invalid address {} on line {} on file {}!", new Object[]{address, lnr.getLineNumber(), BANNED_IPS, ex});
                }
            });
        }
        catch (Exception ex) {
            LOG.warn("Error while reading the bans file {}!", (Object)BANNED_IPS, (Object)ex);
        }
        LOG.info("Loaded {} banned IPs.", (Object)LoginController.getInstance().getBannedIps().size());
        if (Configuration.server().isLoginRestartEnabled()) {
            LoginServerRestart restartLoginServer = new LoginServerRestart();
            restartLoginServer.setDaemon(true);
            restartLoginServer.start();
            LOG.info("Scheduled restart after {} hours.", (Object)Configuration.server().getLoginRestartTime());
        }
    }

    public void shutdown(boolean restart) {
        Runtime.getRuntime().exit(restart ? 2 : 0);
    }

    class LoginServerRestart
    extends Thread {
        public LoginServerRestart() {
            this.setName("LoginServerRestart");
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    Thread.sleep(Configuration.server().getLoginRestartTime() * 3600000);
                }
                catch (InterruptedException e) {
                    return;
                }
                LoginServer.this.shutdown(true);
            }
        }
    }
}

