/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver.network.clientpackets;

import com.l2jserver.loginserver.GameServerTable;
import com.l2jserver.loginserver.LoginController;
import com.l2jserver.loginserver.config.Configuration;
import com.l2jserver.loginserver.model.AccountInfo;
import com.l2jserver.loginserver.network.L2LoginClient;
import com.l2jserver.loginserver.network.clientpackets.L2LoginClientPacket;
import com.l2jserver.loginserver.network.serverpackets.AccountKicked;
import com.l2jserver.loginserver.network.serverpackets.LoginFail;
import com.l2jserver.loginserver.network.serverpackets.LoginOk;
import com.l2jserver.loginserver.network.serverpackets.ServerList;
import java.net.InetAddress;
import javax.crypto.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestAuthLogin
extends L2LoginClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(RequestAuthLogin.class);
    private final byte[] _raw = new byte[128];
    private String _user;
    private String _password;
    private int _ncotp;

    public String getPassword() {
        return this._password;
    }

    public String getUser() {
        return this._user;
    }

    public int getOneTimePassword() {
        return this._ncotp;
    }

    @Override
    public boolean readImpl() {
        if (this._buf.remaining() >= 128) {
            this.readB(this._raw);
            return true;
        }
        return false;
    }

    public void run() {
        byte[] decrypted;
        L2LoginClient client = (L2LoginClient)this.getClient();
        try {
            Cipher rsaCipher = Cipher.getInstance("RSA/ECB/nopadding");
            rsaCipher.init(2, client.getRSAPrivateKey());
            decrypted = rsaCipher.doFinal(this._raw, 0, 128);
        }
        catch (Exception ex) {
            LOG.warn("There has been an error trying to login!", (Throwable)ex);
            return;
        }
        try {
            this._user = new String(decrypted, 94, 14).trim().toLowerCase();
            this._password = new String(decrypted, 108, 16).trim();
            this._ncotp = decrypted[124];
            this._ncotp |= decrypted[125] << 8;
            this._ncotp |= decrypted[126] << 16;
            this._ncotp |= decrypted[127] << 24;
        }
        catch (Exception ex) {
            LOG.warn("There has been an error parsing credentials!", (Throwable)ex);
            return;
        }
        InetAddress clientAddr = ((L2LoginClient)this.getClient()).getConnection().getInetAddress();
        LoginController lc = LoginController.getInstance();
        AccountInfo info = lc.retrieveAccountInfo(clientAddr, this._user, this._password);
        if (info == null) {
            client.close(LoginFail.LoginFailReason.REASON_USER_OR_PASS_WRONG);
            return;
        }
        LoginController.AuthLoginResult result = lc.tryCheckinAccount(client, clientAddr, info);
        switch (result) {
            case AUTH_SUCCESS: {
                client.setAccount(info.getLogin());
                client.setState(L2LoginClient.LoginClientState.AUTHED_LOGIN);
                client.setSessionKey(lc.assignSessionKeyToClient(info.getLogin(), client));
                lc.getCharactersOnAccount(info.getLogin());
                if (Configuration.server().showLicense()) {
                    client.sendPacket(new LoginOk(((L2LoginClient)this.getClient()).getSessionKey()));
                    break;
                }
                ((L2LoginClient)this.getClient()).sendPacket(new ServerList((L2LoginClient)this.getClient()));
                break;
            }
            case INVALID_PASSWORD: {
                client.close(LoginFail.LoginFailReason.REASON_USER_OR_PASS_WRONG);
                break;
            }
            case ACCOUNT_INACTIVE: {
                client.close(LoginFail.LoginFailReason.REASON_INACTIVE);
                break;
            }
            case ACCOUNT_BANNED: {
                client.close(new AccountKicked(AccountKicked.AccountKickedReason.REASON_PERMANENTLY_BANNED));
                break;
            }
            case ALREADY_ON_LS: {
                L2LoginClient oldClient = lc.getAuthedClient(info.getLogin());
                if (oldClient != null) {
                    oldClient.close(LoginFail.LoginFailReason.REASON_ACCOUNT_IN_USE);
                    lc.removeAuthedLoginClient(info.getLogin());
                }
                client.close(LoginFail.LoginFailReason.REASON_ACCOUNT_IN_USE);
                break;
            }
            case ALREADY_ON_GS: {
                GameServerTable.GameServerInfo gsi = lc.getAccountOnGameServer(info.getLogin());
                if (gsi == null) break;
                client.close(LoginFail.LoginFailReason.REASON_ACCOUNT_IN_USE);
                if (!gsi.isAuthed()) break;
                gsi.getGameServerThread().kickPlayer(info.getLogin());
            }
        }
    }
}

