/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver.network.gameserverpackets;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.commons.network.BaseRecievePacket;
import com.l2jserver.loginserver.GameServerTable;
import com.l2jserver.loginserver.GameServerThread;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangePassword
extends BaseRecievePacket {
    private static final Logger LOG = LoggerFactory.getLogger(ChangePassword.class);
    private static GameServerThread gst = null;

    public ChangePassword(byte[] decrypt) {
        block42: {
            super(decrypt);
            String accountName = this.readS();
            String characterName = this.readS();
            String currentPassword = this.readS();
            String newPassword = this.readS();
            for (GameServerTable.GameServerInfo gsi : GameServerTable.getInstance().getRegisteredGameServers().values()) {
                if (gsi.getGameServerThread() == null || !gsi.getGameServerThread().hasAccountOnGameServer(accountName)) continue;
                gst = gsi.getGameServerThread();
            }
            if (gst == null) {
                return;
            }
            if (currentPassword == null || newPassword == null) {
                gst.ChangePasswordResponse((byte)0, characterName, "Invalid password data! Try again.");
            } else {
                try {
                    MessageDigest md = MessageDigest.getInstance("SHA");
                    byte[] raw = md.digest(currentPassword.getBytes(StandardCharsets.UTF_8));
                    String currentPasswordEnc = Base64.getEncoder().encodeToString(raw);
                    String pass = null;
                    try (Connection con = ConnectionFactory.getInstance().getConnection();
                         PreparedStatement ps = con.prepareStatement("SELECT password FROM accounts WHERE login=?");){
                        ps.setString(1, accountName);
                        try (ResultSet rs = ps.executeQuery();){
                            if (rs.next()) {
                                pass = rs.getString("password");
                            }
                        }
                    }
                    if (currentPasswordEnc.equals(pass)) {
                        int passUpdated;
                        byte[] password = md.digest(newPassword.getBytes(StandardCharsets.UTF_8));
                        String newPasswordEnc = Base64.getEncoder().encodeToString(password);
                        try (Connection con = ConnectionFactory.getInstance().getConnection();
                             PreparedStatement ps = con.prepareStatement("UPDATE accounts SET password=? WHERE login=?");){
                            ps.setString(1, newPasswordEnc);
                            ps.setString(2, accountName);
                            passUpdated = ps.executeUpdate();
                        }
                        LOG.info("The password for account {} has been changed from {} to {}.", new Object[]{accountName, currentPasswordEnc, newPasswordEnc});
                        if (passUpdated > 0) {
                            gst.ChangePasswordResponse((byte)1, characterName, "You have successfully changed your password!");
                        } else {
                            gst.ChangePasswordResponse((byte)0, characterName, "The password change was unsuccessful!");
                        }
                        break block42;
                    }
                    gst.ChangePasswordResponse((byte)0, characterName, "The typed current password doesn't match with your current one.");
                }
                catch (Exception ex) {
                    LOG.warn("Error while changing password for account {} requested by player {}!", new Object[]{accountName, characterName, ex});
                }
            }
        }
    }
}

