/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver.network.gameserverpackets;

import com.l2jserver.commons.dao.ServerNameDAO;
import com.l2jserver.commons.network.BaseRecievePacket;
import com.l2jserver.loginserver.GameServerTable;
import com.l2jserver.loginserver.GameServerThread;
import com.l2jserver.loginserver.config.Configuration;
import com.l2jserver.loginserver.model.GameServerVersion;
import com.l2jserver.loginserver.network.L2JGameServerPacketHandler;
import com.l2jserver.loginserver.network.loginserverpackets.AuthResponse;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameServerAuth
extends BaseRecievePacket {
    private static final Logger LOG = LoggerFactory.getLogger(GameServerAuth.class);
    private final GameServerThread _server;
    private final byte[] _hexId;
    private final int _desiredId;
    private final boolean _hostReserved;
    private final boolean _acceptAlternativeId;
    private final int _maxPlayers;
    private final int _serverVersion;
    private final int _port;
    private final String[] _hosts;

    public GameServerAuth(byte[] decrypt, GameServerThread server) {
        super(decrypt);
        this._server = server;
        this._serverVersion = this.readC();
        this._desiredId = this.readC();
        this._acceptAlternativeId = this.readC() != 0;
        this._hostReserved = this.readC() != 0;
        this._port = this.readH();
        this._maxPlayers = this.readD();
        int size = this.readD();
        this._hexId = this.readB(size);
        size = 2 * this.readD();
        this._hosts = new String[size];
        for (int i = 0; i < size; ++i) {
            this._hosts[i] = this.readS();
        }
        if (Configuration.server().isDebug()) {
            LOG.info("Auth request received.");
        }
        if (this.handleRegProcess()) {
            server.sendPacket(new AuthResponse(server.getGameServerInfo().getId()));
            LOG.info("Game Server {} enabled.", (Object)GameServerVersion.valueOf(this._serverVersion));
            server.broadcastToTelnet("GameServer [" + server.getServerId() + "] " + ServerNameDAO.getServer((int)server.getServerId()) + " is connected");
            server.setLoginConnectionState(L2JGameServerPacketHandler.GameServerState.AUTHED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleRegProcess() {
        if (!Configuration.server().getServerVersions().contains(this._serverVersion)) {
            this._server.forceClose(0);
            return false;
        }
        GameServerTable gameServerTable = GameServerTable.getInstance();
        int id = this._desiredId;
        byte[] hexId = this._hexId;
        GameServerTable.GameServerInfo gsi = gameServerTable.getRegisteredGameServerById(id);
        if (gsi != null) {
            if (Arrays.equals(gsi.getHexId(), hexId)) {
                GameServerTable.GameServerInfo gameServerInfo = gsi;
                synchronized (gameServerInfo) {
                    if (gsi.isAuthed()) {
                        this._server.forceClose(7);
                        return false;
                    }
                    this._server.attachGameServerInfo(gsi, this._port, this._hosts, this._maxPlayers);
                    return true;
                }
            }
            if (Configuration.server().isAcceptNetGameServer() && this._acceptAlternativeId) {
                gsi = new GameServerTable.GameServerInfo(id, hexId, this._server);
                if (gameServerTable.registerWithFirstAvailableId(gsi)) {
                    this._server.attachGameServerInfo(gsi, this._port, this._hosts, this._maxPlayers);
                    gameServerTable.registerServerOnDB(gsi);
                    return true;
                }
                this._server.forceClose(5);
                return false;
            }
            this._server.forceClose(3);
            return false;
        }
        if (!Configuration.server().isAcceptNetGameServer()) {
            this._server.forceClose(3);
            return false;
        }
        gsi = new GameServerTable.GameServerInfo(id, hexId, this._server);
        if (gameServerTable.register(id, gsi)) {
            this._server.attachGameServerInfo(gsi, this._port, this._hosts, this._maxPlayers);
            gameServerTable.registerServerOnDB(gsi);
            return true;
        }
        this._server.forceClose(4);
        return false;
    }
}

