/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver;

import com.l2jserver.loginserver.config.Configuration;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FloodProtectedListener
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(FloodProtectedListener.class);
    private final Map<String, ForeignConnection> _floodProtection = new ConcurrentHashMap<String, ForeignConnection>();
    private final ServerSocket _serverSocket;

    public FloodProtectedListener(String listenIp, int port) throws Exception {
        this._serverSocket = listenIp.equals("*") ? new ServerSocket(port) : new ServerSocket(port, 50, InetAddress.getByName(listenIp));
    }

    @Override
    public void run() {
        while (!this.isInterrupted()) {
            try {
                Socket connection = this._serverSocket.accept();
                if (Configuration.server().isFloodProtectionEnabled()) {
                    ForeignConnection fConnection = this._floodProtection.get(connection.getInetAddress().getHostAddress());
                    if (fConnection != null) {
                        ++fConnection.connectionNumber;
                        if (fConnection.connectionNumber > Configuration.server().getFastConnectionLimit() && System.currentTimeMillis() - fConnection.lastConnection < (long)Configuration.server().getNormalConnectionTime() || System.currentTimeMillis() - fConnection.lastConnection < (long)Configuration.server().getFastConnectionTime() || fConnection.connectionNumber > Configuration.server().getMaxConnectionPerIP()) {
                            fConnection.lastConnection = System.currentTimeMillis();
                            connection.close();
                            --fConnection.connectionNumber;
                            if (!fConnection.isFlooding) {
                                LOG.warn("Potential Flood from {}!", (Object)connection.getInetAddress().getHostAddress());
                            }
                            fConnection.isFlooding = true;
                            continue;
                        }
                        if (fConnection.isFlooding) {
                            fConnection.isFlooding = false;
                            LOG.info("Connection {} is not considered as flooding anymore.", (Object)connection.getInetAddress().getHostAddress());
                        }
                        fConnection.lastConnection = System.currentTimeMillis();
                    } else {
                        fConnection = new ForeignConnection(System.currentTimeMillis());
                        this._floodProtection.put(connection.getInetAddress().getHostAddress(), fConnection);
                    }
                }
                this.addClient(connection);
            }
            catch (Exception e) {
                if (!this.isInterrupted()) continue;
                this.close();
                break;
            }
        }
    }

    public abstract void addClient(Socket var1);

    public void removeFloodProtection(String ip) {
        if (!Configuration.server().isFloodProtectionEnabled()) {
            return;
        }
        ForeignConnection fConnection = this._floodProtection.get(ip);
        if (fConnection != null) {
            --fConnection.connectionNumber;
            if (fConnection.connectionNumber == 0) {
                this._floodProtection.remove(ip);
            }
        } else {
            LOG.warn("Removing a flood protection for a Game Server ({}) that was not in the connection map???", (Object)ip);
        }
    }

    public void close() {
        try {
            this._serverSocket.close();
        }
        catch (Exception ex) {
            LOG.warn("There has been an error closing the connection!", (Throwable)ex);
        }
    }

    protected static class ForeignConnection {
        public int connectionNumber;
        public long lastConnection;
        public boolean isFlooding = false;

        public ForeignConnection(long time) {
            this.lastConnection = time;
            this.connectionNumber = 1;
        }
    }
}

