/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver.mail;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.loginserver.config.Configuration;
import com.l2jserver.loginserver.mail.MailSystem;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseMail
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(BaseMail.class);
    private MimeMessage _messageMime = null;

    public BaseMail(String account, String mailId, String ... args) {
        String mailAddr = this.getUserMail(account);
        if (mailAddr == null) {
            return;
        }
        MailSystem.MailContent content = MailSystem.getInstance().getMailContent(mailId);
        if (content == null) {
            return;
        }
        String message = this.compileHtml(account, content.getText(), args);
        Properties mailProp = new Properties();
        mailProp.put("mail.smtp.host", Configuration.email().getHost());
        mailProp.put("mail.smtp.auth", (Object)Configuration.email().isSmtpAuthRequired());
        mailProp.put("mail.smtp.port", (Object)Configuration.email().getPort());
        mailProp.put("mail.smtp.socketFactory.port", (Object)Configuration.email().getPort());
        mailProp.put("mail.smtp.socketFactory.class", Configuration.email().getSmtpFactory());
        mailProp.put("mail.smtp.socketFactory.fallback", (Object)Configuration.email().smtpFactoryCallback());
        SmtpAuthenticator authenticator = Configuration.email().isSmtpAuthRequired() ? new SmtpAuthenticator() : null;
        Session mailSession = Session.getDefaultInstance((Properties)mailProp, (Authenticator)authenticator);
        try {
            this._messageMime = new MimeMessage(mailSession);
            this._messageMime.setSubject(content.getSubject());
            try {
                this._messageMime.setFrom((Address)new InternetAddress(Configuration.email().getServerEmail(), Configuration.email().getServerName()));
            }
            catch (UnsupportedEncodingException ex) {
                LOG.warn("Sender address {} is not Valid!", (Object)Configuration.email().getServerEmail());
            }
            this._messageMime.setContent((Object)message, "text/html");
            this._messageMime.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(mailAddr));
        }
        catch (MessagingException ex) {
            LOG.warn("There has been an error sending the email!", (Throwable)ex);
        }
    }

    private String compileHtml(String account, String html, String[] args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                html = html.replace("%var" + i + "%", args[i]);
            }
        }
        return html.replace("%accountname%", account);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getUserMail(String username) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement statement = con.prepareStatement(Configuration.email().getSelectQuery());){
            statement.setString(1, username);
            try (ResultSet rs = statement.executeQuery();){
                if (!rs.next()) return null;
                String string = rs.getString(Configuration.email().getDatabaseField());
                return string;
            }
        }
        catch (Exception ex) {
            LOG.warn("Cannot select user mail!", (Throwable)ex);
        }
        return null;
    }

    @Override
    public void run() {
        try {
            if (this._messageMime != null) {
                Transport.send((Message)this._messageMime);
            }
        }
        catch (MessagingException ex) {
            LOG.warn("There has been an error while sending email!", (Throwable)ex);
        }
    }

    private static class SmtpAuthenticator
    extends Authenticator {
        private final PasswordAuthentication _auth = new PasswordAuthentication(Configuration.email().getSmtpUsername(), Configuration.email().getSmtpPassword());

        public PasswordAuthentication getPasswordAuthentication() {
            return this._auth;
        }
    }
}

