/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver.mail;

import com.l2jserver.loginserver.config.Configuration;
import com.l2jserver.loginserver.mail.BaseMail;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MailSystem {
    private static final Logger LOG = LoggerFactory.getLogger(MailSystem.class);
    private final Map<String, MailContent> _mailData = new HashMap<String, MailContent>();

    public MailSystem() {
        this.loadMails();
    }

    public void sendMail(String account, String messageId, String ... args) {
        BaseMail mail = new BaseMail(account, messageId, args);
        mail.run();
    }

    private void loadMails() {
        Document doc;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        File file = new File(Configuration.server().getDatapackRoot() + "data/mail/MailList.xml");
        if (!file.exists()) {
            LOG.warn("Cannot load email system - Missing file MailList.xml");
            return;
        }
        try {
            doc = factory.newDocumentBuilder().parse(file);
        }
        catch (Exception ex) {
            LOG.warn("Could not parse MailList.xml file!", (Throwable)ex);
            return;
        }
        Node n = doc.getFirstChild();
        for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
            if (!d.getNodeName().equals("mail")) continue;
            String mailId = d.getAttributes().getNamedItem("id").getNodeValue();
            String subject = d.getAttributes().getNamedItem("subject").getNodeValue();
            String maFile = d.getAttributes().getNamedItem("file").getNodeValue();
            File mailFile = new File(Configuration.server().getDatapackRoot() + "data/mail/" + maFile);
            try (FileInputStream fis = new FileInputStream(mailFile);
                 BufferedInputStream bis = new BufferedInputStream(fis);){
                int bytes = bis.available();
                byte[] raw = new byte[bytes];
                bis.read(raw);
                String html = new String(raw, StandardCharsets.UTF_8);
                html = html.replaceAll(System.lineSeparator(), "\n");
                html = html.replace("%servermail%", Configuration.email().getServerEmail());
                html = html.replace("%servername%", Configuration.email().getServerName());
                this._mailData.put(mailId, new MailContent(subject, html));
                continue;
            }
            catch (IOException ex) {
                LOG.warn("There has been an error while reading {}!", (Object)maFile, (Object)ex);
            }
        }
        LOG.info("Email system loaded.");
    }

    public MailContent getMailContent(String mailId) {
        return this._mailData.get(mailId);
    }

    public static MailSystem getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public static class MailContent {
        private final String _subject;
        private final String _text;

        public MailContent(String subject, String text) {
            this._subject = subject;
            this._text = text;
        }

        public String getSubject() {
            return this._subject;
        }

        public String getText() {
            return this._text;
        }
    }

    private static class SingletonHolder {
        protected static final MailSystem INSTANCE = new MailSystem();

        private SingletonHolder() {
        }
    }
}

