/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver.network;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.loginserver.LoginController;
import com.l2jserver.loginserver.SessionKey;
import com.l2jserver.loginserver.network.serverpackets.L2LoginServerPacket;
import com.l2jserver.loginserver.network.serverpackets.LoginFail;
import com.l2jserver.loginserver.network.serverpackets.PlayFail;
import com.l2jserver.loginserver.security.ScrambledKeyPair;
import com.l2jserver.loginserver.security.crypt.LoginCrypt;
import com.l2jserver.mmocore.MMOClient;
import com.l2jserver.mmocore.MMOConnection;
import com.l2jserver.mmocore.SendablePacket;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class L2LoginClient
extends MMOClient<MMOConnection<L2LoginClient>> {
    private static final Logger LOG = LoggerFactory.getLogger(L2LoginClient.class);
    private LoginClientState _state = LoginClientState.CONNECTED;
    private final LoginCrypt _loginCrypt;
    private final ScrambledKeyPair _scrambledPair = LoginController.getInstance().getScrambledRSAKeyPair();
    private final byte[] _blowfishKey = LoginController.getInstance().getBlowfishKey();
    private String _account;
    private int _accessLevel;
    private int _lastServer;
    private SessionKey _sessionKey;
    private final int _sessionId = Rnd.nextInt();
    private boolean _joinedGS;
    private Map<Integer, Integer> _charsOnServers;
    private Map<Integer, long[]> _charsToDelete;
    private final long _connectionStartTime = System.currentTimeMillis();

    public L2LoginClient(MMOConnection<L2LoginClient> con) {
        super(con);
        this._loginCrypt = new LoginCrypt();
        this._loginCrypt.setKey(this._blowfishKey);
    }

    public boolean decrypt(ByteBuffer buf, int size) {
        try {
            if (!this._loginCrypt.decrypt(buf.array(), buf.position(), size)) {
                LOG.warn("Wrong checksum from client {}!", (Object)this);
                super.getConnection().close((SendablePacket)null);
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            LOG.warn("There has been an error decrypting message!", (Throwable)ex);
            super.getConnection().close((SendablePacket)null);
            return false;
        }
    }

    public boolean encrypt(ByteBuffer buf, int size) {
        int offset = buf.position();
        try {
            size = this._loginCrypt.encrypt(buf.array(), offset, size);
        }
        catch (IOException ex) {
            LOG.warn("There has been an error encrypting message!", (Throwable)ex);
            return false;
        }
        buf.position(offset + size);
        return true;
    }

    public LoginClientState getState() {
        return this._state;
    }

    public void setState(LoginClientState state) {
        this._state = state;
    }

    public byte[] getBlowfishKey() {
        return this._blowfishKey;
    }

    public byte[] getScrambledModulus() {
        return this._scrambledPair.getScrambledModulus();
    }

    public RSAPrivateKey getRSAPrivateKey() {
        return (RSAPrivateKey)this._scrambledPair.getPair().getPrivate();
    }

    public String getAccount() {
        return this._account;
    }

    public void setAccount(String account) {
        this._account = account;
    }

    public void setAccessLevel(int accessLevel) {
        this._accessLevel = accessLevel;
    }

    public int getAccessLevel() {
        return this._accessLevel;
    }

    public void setLastServer(int lastServer) {
        this._lastServer = lastServer;
    }

    public int getLastServer() {
        return this._lastServer;
    }

    public int getSessionId() {
        return this._sessionId;
    }

    public boolean hasJoinedGS() {
        return this._joinedGS;
    }

    public void setJoinedGS(boolean val) {
        this._joinedGS = val;
    }

    public void setSessionKey(SessionKey sessionKey) {
        this._sessionKey = sessionKey;
    }

    public SessionKey getSessionKey() {
        return this._sessionKey;
    }

    public long getConnectionStartTime() {
        return this._connectionStartTime;
    }

    public void sendPacket(L2LoginServerPacket lsp) {
        this.getConnection().sendPacket((SendablePacket)lsp);
    }

    public void close(LoginFail.LoginFailReason reason) {
        this.getConnection().close((SendablePacket)new LoginFail(reason));
    }

    public void close(PlayFail.PlayFailReason reason) {
        this.getConnection().close((SendablePacket)new PlayFail(reason));
    }

    public void close(L2LoginServerPacket lsp) {
        this.getConnection().close((SendablePacket)lsp);
    }

    public void setCharsOnServ(int servId, int chars) {
        if (this._charsOnServers == null) {
            this._charsOnServers = new HashMap<Integer, Integer>();
        }
        this._charsOnServers.put(servId, chars);
    }

    public Map<Integer, Integer> getCharsOnServ() {
        return this._charsOnServers;
    }

    public void serCharsWaitingDelOnServ(int servId, long[] charsToDel) {
        if (this._charsToDelete == null) {
            this._charsToDelete = new HashMap<Integer, long[]>();
        }
        this._charsToDelete.put(servId, charsToDel);
    }

    public Map<Integer, long[]> getCharsWaitingDelOnServ() {
        return this._charsToDelete;
    }

    public void onDisconnection() {
        if (!this.hasJoinedGS() || this.getConnectionStartTime() + 60000L < System.currentTimeMillis()) {
            LoginController.getInstance().removeAuthedLoginClient(this.getAccount());
        }
    }

    public String toString() {
        InetAddress address = this.getConnection().getInetAddress();
        if (this.getState() == LoginClientState.AUTHED_LOGIN) {
            return "[" + this.getAccount() + " (" + (address == null ? "disconnected" : address.getHostAddress()) + ")]";
        }
        return "[" + (address == null ? "disconnected" : address.getHostAddress()) + "]";
    }

    protected void onForcedDisconnection() {
    }

    public static enum LoginClientState {
        CONNECTED,
        AUTHED_GG,
        AUTHED_LOGIN;

    }
}

