/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver.network;

import com.l2jserver.loginserver.network.L2LoginClient;
import com.l2jserver.loginserver.network.clientpackets.AuthGameGuard;
import com.l2jserver.loginserver.network.clientpackets.L2LoginClientPacket;
import com.l2jserver.loginserver.network.clientpackets.RequestAuthLogin;
import com.l2jserver.loginserver.network.clientpackets.RequestServerList;
import com.l2jserver.loginserver.network.clientpackets.RequestServerLogin;
import com.l2jserver.mmocore.PacketHandler;
import com.l2jserver.mmocore.ReceivablePacket;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class L2LoginPacketHandler
implements PacketHandler<L2LoginClient> {
    private static final Logger LOG = LoggerFactory.getLogger(L2LoginPacketHandler.class);

    public ReceivablePacket<L2LoginClient> handlePacket(ByteBuffer buf, L2LoginClient client) {
        int opcode = buf.get() & 0xFF;
        L2LoginClientPacket packet = null;
        L2LoginClient.LoginClientState state = client.getState();
        block0 : switch (state) {
            case CONNECTED: {
                if (opcode == 7) {
                    packet = new AuthGameGuard();
                    break;
                }
                this.debugOpcode(opcode, state);
                break;
            }
            case AUTHED_GG: {
                if (opcode == 0) {
                    packet = new RequestAuthLogin();
                    break;
                }
                this.debugOpcode(opcode, state);
                break;
            }
            case AUTHED_LOGIN: {
                switch (opcode) {
                    case 2: {
                        packet = new RequestServerLogin();
                        break block0;
                    }
                    case 5: {
                        packet = new RequestServerList();
                        break block0;
                    }
                }
                this.debugOpcode(opcode, state);
            }
        }
        return packet;
    }

    private void debugOpcode(int opcode, L2LoginClient.LoginClientState state) {
        LOG.warn("Unknown Opcode {} for state {}!", (Object)opcode, (Object)state.name());
    }
}

