/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver.status;

import com.l2jserver.loginserver.GameServerTable;
import com.l2jserver.loginserver.LoginController;
import com.l2jserver.loginserver.LoginServer;
import com.l2jserver.loginserver.config.Configuration;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoginStatusThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(LoginStatusThread.class);
    private final Socket _cSocket;
    private final PrintWriter _print;
    private final BufferedReader _read;
    private boolean _redirectLogger;

    private void telnetOutput(int type, String text) {
        if (type == 1) {
            System.out.println("TELNET | " + text);
        } else if (type == 2) {
            System.out.print("TELNET | " + text);
        } else if (type == 3) {
            System.out.print(text);
        } else if (type == 4) {
            System.out.println(text);
        } else {
            System.out.println("TELNET | " + text);
        }
    }

    private boolean isValidIP(Socket client) {
        boolean result = false;
        InetAddress clientIP = client.getInetAddress();
        String clientStringIP = clientIP.getHostAddress();
        this.telnetOutput(1, "Connection from: " + clientStringIP);
        if (Configuration.server().isDebug()) {
            this.telnetOutput(2, "");
        }
        if (Configuration.server().isDebug()) {
            this.telnetOutput(3, "Comparing ip to list...");
        }
        for (String host : Configuration.telnet().getHosts()) {
            try {
                String ipToCompare = InetAddress.getByName(host).getHostAddress();
                if (clientStringIP.equals(ipToCompare)) {
                    result = true;
                }
                if (!Configuration.server().isDebug()) continue;
                this.telnetOutput(3, clientStringIP + " = " + ipToCompare + "(" + host + ") = " + result);
            }
            catch (Exception ex) {
                LOG.warn("There has been an error parsing host {}!", (Object)host, (Object)ex);
            }
        }
        if (Configuration.server().isDebug()) {
            this.telnetOutput(4, "Allow IP: " + result);
        }
        return result;
    }

    public LoginStatusThread(Socket client, int uptime, String StatusPW) throws Exception {
        this._cSocket = client;
        this._print = new PrintWriter(this._cSocket.getOutputStream());
        this._read = new BufferedReader(new InputStreamReader(this._cSocket.getInputStream()));
        if (this.isValidIP(client)) {
            this.telnetOutput(1, client.getInetAddress().getHostAddress() + " accepted.");
            this._print.println("Welcome To The L2J Telnet Session.");
            this._print.println("Please Insert Your Password!");
            this._print.print("Password: ");
            this._print.flush();
            String tmpLine = this._read.readLine();
            if (tmpLine == null) {
                this._print.println("Error.");
                this._print.println("Disconnected...");
                this._print.flush();
                this._cSocket.close();
            } else if (!tmpLine.equals(StatusPW)) {
                this._print.println("Incorrect Password!");
                this._print.println("Disconnected...");
                this._print.flush();
                this._cSocket.close();
            } else {
                this._print.println("Password Correct!");
                this._print.println("[L2J Login Server]");
                this._print.print("");
                this._print.flush();
                this.start();
            }
        } else {
            this.telnetOutput(5, "Connection attempt from " + client.getInetAddress().getHostAddress() + " rejected.");
            this._cSocket.close();
        }
    }

    @Override
    public void run() {
        String _usrCommand = "";
        try {
            while (_usrCommand.compareTo("quit") != 0 && _usrCommand.compareTo("exit") != 0) {
                block21: {
                    _usrCommand = this._read.readLine();
                    if (_usrCommand == null) {
                        this._cSocket.close();
                        break;
                    }
                    if (_usrCommand.equals("help")) {
                        this._print.println("The following is a list of all available commands: ");
                        this._print.println("help                - shows this help.");
                        this._print.println("status              - displays basic server statistics.");
                        this._print.println("unblock <ip>        - removes <ip> from the ban list.");
                        this._print.println("shutdown            - shuts down server.");
                        this._print.println("restart             - restarts the server.");
                        this._print.println("RedirectLogger      - Telnet will give you some info about server in real time.");
                        this._print.println("quit                - closes telnet session.");
                        this._print.println("");
                    } else if (_usrCommand.equals("status")) {
                        this._print.println("Registered Server Count: " + GameServerTable.getInstance().getRegisteredGameServers().size());
                    } else if (_usrCommand.startsWith("unblock")) {
                        try {
                            _usrCommand = _usrCommand.substring(8);
                            if (LoginController.getInstance().removeBanForAddress(_usrCommand)) {
                                LOG.warn("IP removed via TELNET by host {}!", (Object)this._cSocket.getInetAddress().getHostAddress());
                                this._print.println("The IP " + _usrCommand + " has been removed from the hack protection list!");
                                break block21;
                            }
                            this._print.println("IP not found in hack protection list...");
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            this._print.println("Please Enter the IP to Unblock!");
                        }
                    } else if (_usrCommand.startsWith("shutdown")) {
                        LoginServer.getInstance().shutdown(false);
                        this._print.println("Bye Bye!");
                        this._print.flush();
                        this._cSocket.close();
                    } else if (_usrCommand.startsWith("restart")) {
                        LoginServer.getInstance().shutdown(true);
                        this._print.println("Bye Bye!");
                        this._print.flush();
                        this._cSocket.close();
                    } else if (_usrCommand.equals("RedirectLogger")) {
                        this._redirectLogger = true;
                    } else if (!_usrCommand.equals("quit") && !_usrCommand.isEmpty()) {
                        this._print.println("Invalid Command");
                    }
                }
                this._print.print("");
                this._print.flush();
            }
            if (!this._cSocket.isClosed()) {
                this._print.println("Bye Bye!");
                this._print.flush();
                this._cSocket.close();
            }
            this.telnetOutput(1, "Connection from " + this._cSocket.getInetAddress().getHostAddress() + " was closed by client.");
        }
        catch (Exception ex) {
            LOG.warn("There has been an error executing login status task!", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printToTelnet(String msg) {
        PrintWriter printWriter = this._print;
        synchronized (printWriter) {
            this._print.println(msg);
            this._print.flush();
        }
    }

    public boolean isRedirectLogger() {
        return this._redirectLogger;
    }
}

