/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver.status;

import com.l2jserver.commons.util.Util;
import com.l2jserver.loginserver.config.Configuration;
import com.l2jserver.loginserver.status.LoginStatusThread;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Status
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(Status.class);
    private final ServerSocket statusServerSocket;
    private final int _uptime;
    private String _statusPw = Configuration.telnet().getPassword();
    private final List<LoginStatusThread> _loginStatus;

    public Status() throws IOException {
        super("Status");
        if (this._statusPw == null) {
            this._statusPw = Util.randomPassword((int)10);
            LOG.info("Server's Telnet function has no password defined!");
            LOG.info("A password has been automatically created!");
            LOG.info("Password has been set to: {}", (Object)this._statusPw);
        }
        this.statusServerSocket = new ServerSocket(Configuration.telnet().getPort());
        this._uptime = (int)System.currentTimeMillis();
        this._loginStatus = new LinkedList<LoginStatusThread>();
        LOG.info("Telnet server started successfully, listening on port {}.", (Object)Configuration.telnet().getPort());
    }

    @Override
    public void run() {
        this.setPriority(10);
        while (!this.isInterrupted()) {
            try {
                Socket connection = this.statusServerSocket.accept();
                LoginStatusThread lst = new LoginStatusThread(connection, this._uptime, this._statusPw);
                if (lst.isAlive()) {
                    this._loginStatus.add(lst);
                }
                if (!this.isInterrupted()) continue;
                try {
                    this.statusServerSocket.close();
                }
                catch (Exception ex) {
                    LOG.warn("There has been an error closing status server socket!", (Throwable)ex);
                }
            }
            catch (Exception ex1) {
                if (!this.isInterrupted()) continue;
                try {
                    this.statusServerSocket.close();
                }
                catch (Exception ex2) {
                    LOG.warn("There has been an error closing status server socket!", (Throwable)ex2);
                }
            }
            break;
        }
    }

    public void sendMessageToTelnets(String msg) {
        for (LoginStatusThread ls : this._loginStatus) {
            if (ls.isInterrupted()) continue;
            ls.printToTelnet(msg);
        }
    }
}

