/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;

public class IPSubnet {
    final byte[] _addr;
    final byte[] _mask;
    final boolean _isIPv4;

    public IPSubnet(String input) throws UnknownHostException, NumberFormatException, ArrayIndexOutOfBoundsException {
        int idx = input.indexOf("/");
        if (idx > 0) {
            this._addr = InetAddress.getByName(input.substring(0, idx)).getAddress();
            this._mask = IPSubnet.getMask(Integer.parseInt(input.substring(idx + 1)), this._addr.length);
            boolean bl = this._isIPv4 = this._addr.length == 4;
            if (!this.applyMask(this._addr)) {
                throw new UnknownHostException(input);
            }
        } else {
            this._addr = InetAddress.getByName(input).getAddress();
            this._mask = IPSubnet.getMask(this._addr.length * 8, this._addr.length);
            this._isIPv4 = this._addr.length == 4;
        }
    }

    public IPSubnet(InetAddress addr, int mask) throws UnknownHostException {
        this._addr = addr.getAddress();
        this._isIPv4 = this._addr.length == 4;
        this._mask = IPSubnet.getMask(mask, this._addr.length);
        if (!this.applyMask(this._addr)) {
            throw new UnknownHostException(String.valueOf(addr) + "/" + mask);
        }
    }

    public byte[] getAddress() {
        return this._addr;
    }

    public boolean applyMask(byte[] addr) {
        if (this._isIPv4 == (addr.length == 4)) {
            for (int i = 0; i < this._addr.length; ++i) {
                if ((addr[i] & this._mask[i]) == this._addr[i]) continue;
                return false;
            }
        } else if (this._isIPv4) {
            for (int i = 0; i < this._addr.length; ++i) {
                if ((addr[i + 12] & this._mask[i]) == this._addr[i]) continue;
                return false;
            }
        } else {
            for (int i = 0; i < this._addr.length; ++i) {
                if ((addr[i] & this._mask[i + 12]) == this._addr[i + 12]) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        int size = 0;
        for (byte element : this._mask) {
            size += Integer.bitCount(element & 0xFF);
        }
        try {
            return String.valueOf(InetAddress.getByAddress(this._addr)) + "/" + size;
        }
        catch (UnknownHostException e) {
            return "Invalid";
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof IPSubnet) {
            return this.applyMask(((IPSubnet)o).getAddress());
        }
        if (o instanceof InetAddress) {
            return this.applyMask(((InetAddress)o).getAddress());
        }
        return false;
    }

    private static byte[] getMask(int n, int maxLength) throws UnknownHostException {
        if (n > maxLength << 3 || n < 0) {
            throw new UnknownHostException("Invalid netmask: " + n);
        }
        byte[] result = new byte[maxLength];
        Arrays.fill(result, (byte)-1);
        for (int i = (maxLength << 3) - 1; i >= n; --i) {
            result[i >> 3] = (byte)(result[i >> 3] << 1);
        }
        return result;
    }
}

