/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.commons.database;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionFactory.class);
    private static final int MAX_LIFETIME = 10;
    private final HikariDataSource dataSource = new HikariDataSource();

    private ConnectionFactory(Builder builder) {
        this.dataSource.setJdbcUrl(builder.url);
        this.dataSource.setUsername(builder.user);
        this.dataSource.setPassword(builder.password);
        this.dataSource.setMaximumPoolSize(builder.maxPoolSize);
        this.dataSource.setIdleTimeout(TimeUnit.SECONDS.toMillis(builder.maxIdleTime));
        this.dataSource.setMaxLifetime(TimeUnit.MINUTES.toMillis(10L));
    }

    public static ConnectionFactory getInstance() {
        return Builder.INSTANCE;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Connection getConnection() {
        Connection con = null;
        while (con == null) {
            try {
                con = this.getDataSource().getConnection();
            }
            catch (SQLException ex) {
                LOG.warn("Unable to get a connection!", (Throwable)ex);
            }
        }
        return con;
    }

    public void close() {
        try {
            this.dataSource.close();
        }
        catch (Exception e) {
            LOG.warn("There has been a problem closing the data source!", (Throwable)e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        protected static volatile ConnectionFactory INSTANCE;
        private String url;
        private String user;
        private String password;
        private int maxPoolSize;
        private int maxIdleTime;

        private Builder() {
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withUser(String user) {
            this.user = user;
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder withMaxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
            return this;
        }

        public Builder withMaxIdleTime(int maxIdleTime) {
            this.maxIdleTime = maxIdleTime;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void build() {
            if (INSTANCE == null) {
                Builder builder = this;
                synchronized (builder) {
                    if (INSTANCE == null) {
                        INSTANCE = new ConnectionFactory(this);
                    } else {
                        LOG.warn("Trying to build another Connection Factory!");
                    }
                }
            }
        }
    }
}

