/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.commons.util;

import com.l2jserver.commons.util.HexUtils;
import com.l2jserver.commons.util.Rnd;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Util {
    private static final Logger LOG = LoggerFactory.getLogger(Util.class);
    private static final char[] ILLEGAL_CHARACTERS = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f', '`', '?', '*', '\\', '<', '>', '|', '\"', ':'};

    public static boolean isInternalHostname(String host) {
        try {
            InetAddress addr = InetAddress.getByName(host);
            return addr.isSiteLocalAddress() || addr.isLoopbackAddress();
        }
        catch (UnknownHostException e) {
            LOG.warn("Invalid host!", (Throwable)e);
            return false;
        }
    }

    public static String printData(byte[] data, int len) {
        return new String(HexUtils.bArr2HexEdChars(data, len));
    }

    public static String printData(byte[] data) {
        return Util.printData(data, data.length);
    }

    public static String printData(ByteBuffer buf) {
        byte[] data = new byte[buf.remaining()];
        buf.get(data);
        String hex = Util.printData(data, data.length);
        buf.position(buf.position() - data.length);
        return hex;
    }

    public static byte[] generateHex(int size) {
        byte[] array = new byte[size];
        Rnd.nextBytes(array);
        return array;
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String replaceIllegalCharacters(String str) {
        String valid = str;
        for (char c : ILLEGAL_CHARACTERS) {
            valid = valid.replace(c, '_');
        }
        return valid;
    }

    public static boolean isValidFileName(String name) {
        File f = new File(name);
        try {
            f.getCanonicalPath();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String splitWords(String input) {
        return input.replaceAll("(\\p{Ll})(\\p{Lu})", "$1 $2");
    }

    public static LocalDateTime getNextClosestDateTime(DayOfWeek[] daysOfWeek, int hour, int min) throws IllegalArgumentException {
        return Util.getNextClosestDateTime(Arrays.asList(daysOfWeek), hour, min);
    }

    public static LocalDateTime getNextClosestDateTime(List<DayOfWeek> daysOfWeek, int hour, int min) throws IllegalArgumentException {
        if (daysOfWeek.isEmpty()) {
            throw new IllegalArgumentException("daysOfWeek should not be empty.");
        }
        LocalDateTime dateNow = LocalDateTime.now();
        LocalDateTime dateNowWithDifferentTime = dateNow.withHour(hour).withMinute(min).withSecond(0);
        return daysOfWeek.stream().map(d -> dateNowWithDifferentTime.with(TemporalAdjusters.nextOrSame(d))).filter(d -> d.isAfter(dateNow)).min(Comparator.naturalOrder()).orElse(dateNowWithDifferentTime.with(TemporalAdjusters.next(daysOfWeek.getFirst())));
    }

    public static <K, V> Function<K, V> mapToFunction(Map<K, V> map) {
        return map::get;
    }

    public static String parseArg(String[] args, String arg, boolean hasArgValue) {
        if (args == null || arg == null || arg.isEmpty()) {
            return null;
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                if (!arg.equals(args[i])) continue;
                return hasArgValue ? args[i + 1] : arg;
            }
            return null;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Illegal arguments " + Arrays.toString(args) + " and argument " + arg + "!", ex);
        }
    }

    public static String randomPassword(int length) {
        String lowerChar = "qwertyuiopasdfghjklzxcvbnm";
        String upperChar = "QWERTYUIOPASDFGHJKLZXCVBNM";
        String digits = "1234567890";
        StringBuilder password = new StringBuilder(length);
        block5: for (int i = 0; i < length; ++i) {
            int charSet = Rnd.nextInt(3);
            switch (charSet) {
                case 0: {
                    password.append("qwertyuiopasdfghjklzxcvbnm".charAt(Rnd.nextInt("qwertyuiopasdfghjklzxcvbnm".length() - 1)));
                    continue block5;
                }
                case 1: {
                    password.append("QWERTYUIOPASDFGHJKLZXCVBNM".charAt(Rnd.nextInt("QWERTYUIOPASDFGHJKLZXCVBNM".length() - 1)));
                    continue block5;
                }
                case 2: {
                    password.append("1234567890".charAt(Rnd.nextInt("1234567890".length() - 1)));
                }
            }
        }
        return password.toString();
    }
}

