/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.Converters;
import org.aeonbits.owner.Delegate;
import org.aeonbits.owner.DelegateMethodHandle;
import org.aeonbits.owner.Preprocessor;
import org.aeonbits.owner.PreprocessorResolver;
import org.aeonbits.owner.PropertiesManager;
import org.aeonbits.owner.PropertiesMapper;
import org.aeonbits.owner.StrSubstitutor;
import org.aeonbits.owner.util.Reflection;
import org.aeonbits.owner.util.Util;

class PropertiesInvocationHandler
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 5432212884255718342L;
    private transient List<DelegateMethodHandle> delegates;
    private final Object jmxSupport;
    private final StrSubstitutor substitutor;
    final PropertiesManager propertiesManager;

    PropertiesInvocationHandler(PropertiesManager manager, Object jmxSupport) {
        this.propertiesManager = manager;
        this.jmxSupport = jmxSupport;
        this.delegates = this.findDelegates(manager, jmxSupport);
        this.substitutor = new StrSubstitutor(manager.load());
    }

    @Override
    public Object invoke(Object proxy, Method invokedMethod, Object ... args) throws Throwable {
        this.propertiesManager.syncReloadCheck();
        if (Reflection.isDefault(invokedMethod)) {
            return Reflection.invokeDefaultMethod(proxy, invokedMethod, args);
        }
        DelegateMethodHandle delegate = this.getDelegateMethod(invokedMethod);
        if (delegate != null) {
            return delegate.invoke(args);
        }
        return this.resolveProperty(invokedMethod, args);
    }

    private DelegateMethodHandle getDelegateMethod(Method invokedMethod) {
        for (DelegateMethodHandle delegate : this.delegates) {
            if (!delegate.matches(invokedMethod)) continue;
            return delegate;
        }
        return null;
    }

    private Object resolveProperty(Method method, Object ... args) {
        String key = this.expandKey(method, args);
        String value = this.propertiesManager.getProperty(key);
        if (value == null && !Util.isFeatureDisabled(method, Config.DisableableFeature.VARIABLE_EXPANSION)) {
            String unexpandedKey = PropertiesMapper.key(method);
            value = this.propertiesManager.getProperty(unexpandedKey);
        }
        if (value == null) {
            return null;
        }
        value = this.preProcess(method, value);
        Object result = Converters.convert(method, method.getReturnType(), this.format(method, this.propertiesManager.decryptIfNecessary(method, this.expandVariables(method, value)), args));
        if (result == Converters.SpecialValue.NULL) {
            return null;
        }
        return result;
    }

    private String preProcess(Method method, String value) {
        List<Preprocessor> preprocessors = PreprocessorResolver.resolvePreprocessors(method);
        String result = value;
        for (Preprocessor preprocessor : preprocessors) {
            result = preprocessor.process(result);
        }
        return result;
    }

    private String expandKey(Method method, Object ... args) {
        String key = PropertiesMapper.key(method);
        if (Util.isFeatureDisabled(method, Config.DisableableFeature.VARIABLE_EXPANSION)) {
            return key;
        }
        return this.substitutor.replace(key, args);
    }

    private String format(Method method, String format, Object ... args) {
        if (Util.isFeatureDisabled(method, Config.DisableableFeature.PARAMETER_FORMATTING)) {
            return format;
        }
        if (args == null || args.length == 0) {
            return format;
        }
        try {
            return String.format(format, args);
        }
        catch (Exception e) {
            return format;
        }
    }

    private String expandVariables(Method method, String value) {
        if (Util.isFeatureDisabled(method, Config.DisableableFeature.VARIABLE_EXPANSION)) {
            return value;
        }
        return this.substitutor.replace(value);
    }

    private List<DelegateMethodHandle> findDelegates(Object ... targets) {
        LinkedList<DelegateMethodHandle> result = new LinkedList<DelegateMethodHandle>();
        for (Object target : targets) {
            Method[] methods;
            if (target == null) continue;
            for (Method m : methods = target.getClass().getMethods()) {
                if (m.getAnnotation(Delegate.class) == null) continue;
                result.add(new DelegateMethodHandle(target, m));
            }
        }
        return result;
    }

    public <T extends Config> void setProxy(T proxy) {
        this.propertiesManager.setProxy(proxy);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.delegates = this.findDelegates(this.propertiesManager, this.jmxSupport);
    }
}

