/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner.util;

import java.lang.reflect.Method;

public final class Reflection {
    private static final Java8Support JAVA_8_SUPPORT = Reflection.getJava8Support();

    private Reflection() {
    }

    public static boolean isClassAvailable(String className) {
        return Reflection.forName(className) != null;
    }

    public static Class<?> forName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Java8Support getJava8Support() {
        try {
            return (Java8Support)Class.forName("org.aeonbits.owner.util.Java8SupportImpl").newInstance();
        }
        catch (Exception e) {
            return Reflection.java8NotSupported();
        }
    }

    private static Java8Support java8NotSupported() {
        return new Java8Support(){

            @Override
            public boolean isDefault(Method method) {
                return false;
            }

            @Override
            public Object invokeDefaultMethod(Object proxy, Method method, Object[] args) throws Throwable {
                return null;
            }
        };
    }

    public static boolean isDefault(Method method) {
        return JAVA_8_SUPPORT.isDefault(method);
    }

    public static Object invokeDefaultMethod(Object proxy, Method method, Object[] args) throws Throwable {
        return JAVA_8_SUPPORT.invokeDefaultMethod(proxy, method, args);
    }

    static interface Java8Support {
        public boolean isDefault(Method var1);

        public Object invokeDefaultMethod(Object var1, Method var2, Object[] var3) throws Throwable;
    }
}

