/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.commons.network;

import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRecievePacket {
    private static final Logger LOG = LoggerFactory.getLogger(BaseRecievePacket.class);
    private final byte[] _decrypt;
    private int _off;

    public BaseRecievePacket(byte[] decrypt) {
        this._decrypt = decrypt;
        this._off = 1;
    }

    public int readD() {
        int result = this._decrypt[this._off++] & 0xFF;
        result |= this._decrypt[this._off++] << 8 & 0xFF00;
        result |= this._decrypt[this._off++] << 16 & 0xFF0000;
        return result |= this._decrypt[this._off++] << 24 & 0xFF000000;
    }

    public int readC() {
        return this._decrypt[this._off++] & 0xFF;
    }

    public int readH() {
        int result = this._decrypt[this._off++] & 0xFF;
        return result |= this._decrypt[this._off++] << 8 & 0xFF00;
    }

    public double readF() {
        long result = this._decrypt[this._off++] & 0xFF;
        result |= ((long)this._decrypt[this._off++] & 0xFFL) << 8;
        result |= ((long)this._decrypt[this._off++] & 0xFFL) << 16;
        result |= ((long)this._decrypt[this._off++] & 0xFFL) << 24;
        result |= ((long)this._decrypt[this._off++] & 0xFFL) << 32;
        result |= ((long)this._decrypt[this._off++] & 0xFFL) << 40;
        result |= ((long)this._decrypt[this._off++] & 0xFFL) << 48;
        return Double.longBitsToDouble(result |= ((long)this._decrypt[this._off++] & 0xFFL) << 56);
    }

    public String readS() {
        String result = null;
        try {
            result = new String(this._decrypt, this._off, this._decrypt.length - this._off, StandardCharsets.UTF_16LE);
            result = result.substring(0, result.indexOf(0));
            this._off += result.length() * 2 + 2;
        }
        catch (Exception ex) {
            LOG.warn("There has been an error trying to read an String!", (Throwable)ex);
        }
        return result;
    }

    public final byte[] readB(int length) {
        byte[] result = new byte[length];
        System.arraycopy(this._decrypt, this._off, result, 0, length);
        this._off += length;
        return result;
    }

    public long readQ() {
        long result = this._decrypt[this._off++] & 0xFF;
        result |= ((long)this._decrypt[this._off++] & 0xFFL) << 8;
        result |= ((long)this._decrypt[this._off++] & 0xFFL) << 16;
        result |= ((long)this._decrypt[this._off++] & 0xFFL) << 24;
        result |= ((long)this._decrypt[this._off++] & 0xFFL) << 32;
        result |= ((long)this._decrypt[this._off++] & 0xFFL) << 40;
        result |= ((long)this._decrypt[this._off++] & 0xFFL) << 48;
        return result |= ((long)this._decrypt[this._off++] & 0xFFL) << 56;
    }
}

